/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.property.events;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import insane96mcp.mobspropertiesrandomness.data.json.property.MPRProperty;
import insane96mcp.mobspropertiesrandomness.data.json.property.events.MPRHurtData;
import insane96mcp.mobspropertiesrandomness.data.json.property.events.MPROnHitEvent;
import insane96mcp.mobspropertiesrandomness.data.json.property.events.Target;
import insane96mcp.mobspropertiesrandomness.data.json.util.modifiable.MPRModifier;
import insane96mcp.mobspropertiesrandomness.data.json.util.modifiable.MPRRange;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import org.jetbrains.annotations.Nullable;

@JsonAdapter(value=Serializer.class)
public class MPRDamagedEvent
extends MPROnHitEvent {
    public MPRDamagedEvent( @Nullable MPRModifier.Operation damageModifierOperation, @Nullable MPRRange damageAmount, @Nullable MPRRange damageModifier, @Nullable MPRRange healthLeft, boolean flatHealthLeft, MPRHurtData hurtData, ResourceLocation id, Target target, @Nullable List<MPRProperty> applyProperties, List<MPRCondition> conditions) {
        super(damageModifierOperation, damageAmount, damageModifier, healthLeft, flatHealthLeft, hurtData, id, target, applyProperties, conditions);
    }

    public static void onDamaged(LivingDamageEvent event) {
        LivingEntity le;
        LivingEntity mob = event.getEntity();
        DamageSource source = event.getSource();
        if (source.m_7639_() != null && !(source.m_7639_() instanceof LivingEntity)) {
            return;
        }
        Entity entity = source.m_7639_();
        LivingEntity other = entity instanceof LivingEntity ? (le = (LivingEntity)entity) : null;
        boolean directHit = source.m_7640_() == source.m_7639_();
        float amount = event.getAmount();
        List<MPRDamagedEvent> events = MPRDamagedEvent.getEvents(mob, MPRDamagedEvent.class);
        for (MPRDamagedEvent damagedEvent : events) {
            damagedEvent.hit(event, mob, other, source, amount, directHit);
        }
    }

    public static class Serializer
    implements JsonDeserializer<MPROnHitEvent>,
    JsonSerializer<MPROnHitEvent> {
        public MPROnHitEvent deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            MPRRange damageAmount = (MPRRange)GsonHelper.m_13845_((JsonObject)jObject, (String)"damage_amount", null, (JsonDeserializationContext)context, MPRRange.class);
            MPRRange damageModifier = (MPRRange)GsonHelper.m_13845_((JsonObject)jObject, (String)"damage_modifier", null, (JsonDeserializationContext)context, MPRRange.class);
            MPRModifier.Operation damageModifierOperation = (MPRModifier.Operation)((Object)GsonHelper.m_13845_((JsonObject)jObject, (String)"damage_modifier_operation", null, (JsonDeserializationContext)context, MPRModifier.Operation.class));
            if (damageModifier != null && damageModifierOperation == null) {
                throw new JsonParseException("damage_modifier_operation is required when damage_modifier is set");
            }
            MPRRange healthLeft = (MPRRange)GsonHelper.m_13845_((JsonObject)jObject, (String)"health_left", null, (JsonDeserializationContext)context, MPRRange.class);
            String id = GsonHelper.m_13906_((JsonObject)jObject, (String)"id");
            Target target = (Target)((Object)GsonHelper.m_13836_((JsonObject)jObject, (String)"target", (JsonDeserializationContext)context, Target.class));
            List<MPRCondition> conditions = MPRCondition.deserializeConditions(jObject, context);
            List<MPRProperty> properties = MPRProperty.deserializeList(jObject, "apply_properties", context);
            return new MPRDamagedEvent(damageModifierOperation, damageAmount, damageModifier, healthLeft, GsonHelper.m_13855_((JsonObject)jObject, (String)"flat_health_left", (boolean)false), MPRHurtData.deserialize(jObject, context), ResourceLocation.parse((String)id), target, properties, conditions);
        }

        public JsonElement serialize(MPROnHitEvent src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            return src.endSerialization(jObject, context, false);
        }
    }
}

