/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.util.modifiable;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.mobspropertiesrandomness.data.json.util.modifiable.MPRModifiable;
import insane96mcp.mobspropertiesrandomness.data.json.util.modifiable.MPRModifier;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

@JsonAdapter(value=Serializer.class)
public class MPRModifiableValue
extends MPRModifiable {
    public final Double value;
    public static final MPRModifiableValue ZERO = new MPRModifiableValue(0.0);
    public static final MPRModifiableValue ONE = new MPRModifiableValue(1.0);

    public MPRModifiableValue(Double value) {
        this(value, List.of(), null);
    }

    public MPRModifiableValue(Double value, List<MPRModifier> modifiers, @Nullable Integer round) {
        super(modifiers, round);
        this.value = value;
    }

    public double getValue(LivingEntity living) {
        return this.applyModifiersAndRound(this.value, living);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof MPRModifiableValue)) return false;
        MPRModifiableValue modifiableValue = (MPRModifiableValue)obj;
        if (!this.value.equals(modifiableValue.value)) return false;
        if (!this.modifiers.equals(modifiableValue.modifiers)) return false;
        if (!Objects.equals(this.round, modifiableValue.round)) return false;
        return true;
    }

    public static class Serializer
    implements JsonSerializer<MPRModifiableValue>,
    JsonDeserializer<MPRModifiableValue> {
        public MPRModifiableValue deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive()) {
                return new MPRModifiableValue(json.getAsDouble(), List.of(), null);
            }
            JsonObject jObject = json.getAsJsonObject();
            return new MPRModifiableValue(GsonHelper.m_144784_((JsonObject)jObject, (String)"value"), MPRModifiable.deserializeList(jObject, context), (Integer)GsonHelper.m_13845_((JsonObject)jObject, (String)"round", null, (JsonDeserializationContext)context, Integer.class));
        }

        public JsonElement serialize(MPRModifiableValue src, Type typeOfSrc, JsonSerializationContext context) {
            if (src.modifiers.isEmpty() && src.round == null) {
                return new JsonPrimitive((Number)src.value);
            }
            JsonObject jObject = new JsonObject();
            jObject.addProperty("value", (Number)src.value);
            return src.endSerialization(jObject, context);
        }
    }
}

