/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.util.modifiable;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.mobspropertiesrandomness.data.json.util.modifiable.MPRModifiable;
import insane96mcp.mobspropertiesrandomness.data.json.util.modifiable.MPRModifiableValue;
import insane96mcp.mobspropertiesrandomness.data.json.util.modifiable.MPRModifier;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;

@JsonAdapter(value=Serializer.class)
public class MPRRange
extends MPRModifiable {
    public final MPRModifiableValue min;
    public final MPRModifiableValue max;
    private final Bias bias;
    public static final MPRRange ZERO = new MPRRange(MPRModifiableValue.ZERO);
    public static final MPRRange ONE = new MPRRange(MPRModifiableValue.ONE);
    public static final MPRRange UNLIMITED = new MPRRange(-1.7976931348623157E308, Double.MAX_VALUE);

    public MPRRange(MPRModifiableValue value) {
        this(value, null, Bias.NONE, List.of(), null);
    }

    public MPRRange(double value) {
        this(new MPRModifiableValue(value));
    }

    public MPRRange(MPRModifiableValue min, MPRModifiableValue max) {
        this(min, max, Bias.NONE, List.of(), null);
    }

    public MPRRange(double min, double max) {
        this(new MPRModifiableValue(min), new MPRModifiableValue(max), Bias.NONE, List.of(), null);
    }

    public MPRRange(MPRModifiableValue min, @Nullable MPRModifiableValue max, Bias bias, List<MPRModifier> modifiers, @Nullable Integer round) {
        super(modifiers, round);
        this.min = min;
        this.max = max != null ? max : min;
        this.bias = bias;
    }

    public double getMin(LivingEntity living) {
        return this.applyModifiers(this.min.getValue(living), living);
    }

    public double getMax(LivingEntity living) {
        return this.applyModifiers(this.max.getValue(living), living);
    }

    public double getDoubleBetween(LivingEntity entity) {
        double max;
        RandomSource random = entity.m_9236_().f_46441_;
        double min = this.getMin(entity);
        if (min > (max = this.getMax(entity))) {
            return min;
        }
        if (this.bias == Bias.NONE) {
            return Mth.m_216263_((RandomSource)random, (double)min, (double)max);
        }
        if (this.bias == Bias.MIDDLE) {
            return random.m_216328_((min + max) / 2.0, (max - min) / 2.0);
        }
        double t = random.m_188500_();
        double biased = random.m_188500_() * t;
        return this.bias == Bias.MIN ? min + biased * (max - min) : max - biased * (max - min);
    }

    public int getIntBetween(LivingEntity entity) {
        return (int)this.getDoubleBetween(entity);
    }

    public boolean isBetween(LivingEntity entity, double value) {
        return value >= this.getMin(entity) && value <= this.getMax(entity);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof MPRRange)) return false;
        MPRRange range = (MPRRange)obj;
        if (!this.min.equals(range.min)) return false;
        if (!this.max.equals(range.max)) return false;
        if (this.bias != range.bias) return false;
        if (!this.modifiers.equals(range.modifiers)) return false;
        if (!Objects.equals(this.round, range.round)) return false;
        return true;
    }

    public static enum Bias {
        NONE,
        MIN,
        MAX,
        MIDDLE;

    }

    public static enum ModifiersBehaviour {
        BOTH,
        MIN_ONLY,
        MAX_ONLY;

    }

    public static class Serializer
    implements JsonSerializer<MPRRange>,
    JsonDeserializer<MPRRange> {
        public MPRRange deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            MPRModifiableValue min;
            if (json.isJsonPrimitive()) {
                return new MPRRange(json.getAsDouble());
            }
            JsonObject jObject = json.getAsJsonObject();
            if (!jObject.has("min")) {
                if (!jObject.has("value")) {
                    throw new JsonParseException("Missing min or value");
                }
                min = (MPRModifiableValue)GsonHelper.m_13836_((JsonObject)jObject, (String)"value", (JsonDeserializationContext)context, MPRModifiableValue.class);
            } else {
                min = (MPRModifiableValue)GsonHelper.m_13836_((JsonObject)jObject, (String)"min", (JsonDeserializationContext)context, MPRModifiableValue.class);
            }
            MPRModifiableValue max = (MPRModifiableValue)GsonHelper.m_13845_((JsonObject)jObject, (String)"max", (Object)min, (JsonDeserializationContext)context, MPRModifiableValue.class);
            Bias bias = jObject.has("bias") ? (Bias)((Object)GsonHelper.m_13836_((JsonObject)jObject, (String)"bias", (JsonDeserializationContext)context, Bias.class)) : Bias.NONE;
            return new MPRRange(min, max, bias, MPRModifiable.deserializeList(jObject, context), (Integer)GsonHelper.m_13845_((JsonObject)jObject, (String)"round", null, (JsonDeserializationContext)context, Integer.class));
        }

        public JsonElement serialize(MPRRange src, Type typeOfSrc, JsonSerializationContext context) {
            if (Objects.equals(src.min, src.max) && src.modifiers.isEmpty() && src.round == null) {
                return new JsonPrimitive((Number)src.min.value);
            }
            JsonObject jObject = new JsonObject();
            jObject.add("min", context.serialize((Object)src.min));
            if (!Objects.equals(src.min, src.max)) {
                jObject.add("max", context.serialize((Object)src.max));
            }
            return src.endSerialization(jObject, context);
        }
    }
}

