/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.util.modifiable;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import insane96mcp.mobspropertiesrandomness.data.json.util.modifiable.MPRModifiableValue;
import insane96mcp.mobspropertiesrandomness.data.json.util.modifiable.MPRModifier;
import insane96mcp.mobspropertiesrandomness.data.json.util.modifiable.MPRRange;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

@JsonAdapter(value=Serializer.class)
public class MPRTimePlayedModifier
extends MPRModifier {
    public MPRRange amountPerMinutes;
    public MPRModifiableValue minutes;
    public MPRModifiableValue cap;
    public Mode mode;

    public MPRTimePlayedModifier(MPRRange amountPerMinutes, MPRModifiableValue minutes, MPRModifiableValue cap, Mode mode, MPRModifier.Operation operation, List<MPRCondition> conditions) {
        super(operation, conditions);
        this.amountPerMinutes = amountPerMinutes;
        this.minutes = minutes;
        this.cap = cap;
        this.mode = mode;
    }

    @Override
    protected double getModifier(LivingEntity living) {
        List<ServerPlayer> players = new ArrayList();
        double modifier = this.getNoModifier();
        if (this.mode == Mode.NEAREST) {
            ServerPlayer nearestPlayer = (ServerPlayer)living.m_9236_().m_45930_((Entity)living, 128.0);
            if (nearestPlayer == null) {
                return modifier;
            }
            players.add(nearestPlayer);
        } else {
            players = living.m_9236_().m_45976_(ServerPlayer.class, living.m_20191_().m_82400_(128.0));
            if (players.isEmpty()) {
                return modifier;
            }
        }
        for (ServerPlayer player : players) {
            int ticksPlayed = player.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_144255_));
            double minutesPlayed = (double)ticksPlayed / 20.0 / 60.0;
            modifier += minutesPlayed / this.minutes.getValue(living) * this.amountPerMinutes.getDoubleBetween(living);
        }
        if (this.mode == Mode.AVERAGE) {
            modifier /= (double)players.size();
        }
        if (this.cap != null) {
            modifier = Math.min(modifier, this.cap.getValue(living));
        }
        return modifier + this.getNoModifier();
    }

    public static enum Mode {
        AVERAGE,
        SUM,
        NEAREST;

    }

    public static class Serializer
    implements JsonDeserializer<MPRTimePlayedModifier>,
    JsonSerializer<MPRTimePlayedModifier> {
        public MPRTimePlayedModifier deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            return new MPRTimePlayedModifier((MPRRange)GsonHelper.m_13836_((JsonObject)jObject, (String)"amount_per_minutes", (JsonDeserializationContext)context, MPRRange.class), (MPRModifiableValue)GsonHelper.m_13836_((JsonObject)jObject, (String)"minutes", (JsonDeserializationContext)context, MPRModifiableValue.class), (MPRModifiableValue)GsonHelper.m_13845_((JsonObject)jObject, (String)"cap", (Object)new MPRModifiableValue((Double)Double.MAX_VALUE), (JsonDeserializationContext)context, MPRModifiableValue.class), (Mode)((Object)GsonHelper.m_13836_((JsonObject)jObject, (String)"mode", (JsonDeserializationContext)context, Mode.class)), MPRModifier.deserializeOperation(jObject, context), MPRCondition.deserializeConditions(jObject, context));
        }

        public JsonElement serialize(MPRTimePlayedModifier src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            jObject.add("amount_per_minutes", context.serialize((Object)src.amountPerMinutes));
            jObject.add("minutes", context.serialize((Object)src.minutes));
            jObject.add("cap", context.serialize((Object)src.cap));
            jObject.add("mode", context.serialize((Object)src.mode));
            return src.endSerialization(jObject, context);
        }
    }
}

