/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import insane96mcp.mobspropertiesrandomness.data.json.util.NBTType;
import insane96mcp.mobspropertiesrandomness.data.json.util.modifiable.MPRRange;
import java.lang.reflect.Type;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;

@JsonAdapter(value=Serializer.class)
public class MPRNBTCondition
extends MPRCondition {
    public String path;
    public NBTType type;
    public MPRRange value;

    public MPRNBTCondition(String path, NBTType type, MPRRange value, boolean inverted) {
        super(inverted);
        this.path = path;
        this.type = type;
        this.value = value;
    }

    @Override
    protected boolean conditionCheck(LivingEntity living) {
        CompoundTag mobTag = new CompoundTag();
        living.m_20240_(mobTag);
        String[] splitPath = this.path.split("\\.");
        for (int i = 0; i < splitPath.length; ++i) {
            Tag tag = mobTag.m_128423_(splitPath[i]);
            if (tag == null) {
                return false;
            }
            if (i < splitPath.length - 1) {
                if (tag instanceof CompoundTag) {
                    CompoundTag compoundTag;
                    mobTag = compoundTag = (CompoundTag)tag;
                    continue;
                }
                return false;
            }
            switch (this.type) {
                case DOUBLE: {
                    if (tag instanceof DoubleTag) {
                        DoubleTag doubleTag = (DoubleTag)tag;
                        return this.value.isBetween(living, doubleTag.m_7057_());
                    }
                    return false;
                }
                case INTEGER: {
                    if (tag instanceof IntTag) {
                        IntTag intTag = (IntTag)tag;
                        return this.value.isBetween(living, intTag.m_7047_());
                    }
                    return false;
                }
                case BOOLEAN: {
                    if (tag instanceof ByteTag) {
                        ByteTag byteTag = (ByteTag)tag;
                        return this.value.isBetween(living, byteTag.m_7063_());
                    }
                    return false;
                }
            }
        }
        return false;
    }

    public static class Serializer
    implements JsonDeserializer<MPRNBTCondition>,
    JsonSerializer<MPRNBTCondition> {
        public MPRNBTCondition deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            return new MPRNBTCondition(GsonHelper.m_13906_((JsonObject)jObject, (String)"path"), (NBTType)((Object)context.deserialize(jObject.get("type"), NBTType.class)), (MPRRange)context.deserialize(jObject.get("value"), MPRRange.class), MPRCondition.deserializeInverted(jObject));
        }

        public JsonElement serialize(MPRNBTCondition src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            jObject.add("path", context.serialize((Object)src.path));
            jObject.add("type", context.serialize((Object)src.type));
            jObject.add("value", context.serialize((Object)src.value));
            return src.endSerialization(jObject);
        }
    }
}

