/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.property.preset;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.insanelib.util.ModNBTData;
import insane96mcp.insanelib.util.weightedrandom.WeightedRandom;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import insane96mcp.mobspropertiesrandomness.data.json.property.MPRProperty;
import insane96mcp.mobspropertiesrandomness.data.json.property.preset.MPRWeightedPreset;
import insane96mcp.mobspropertiesrandomness.module.base.feature.MPRBase;
import insane96mcp.mobspropertiesrandomness.util.SerializerUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

@JsonAdapter(value=Serializer.class)
public class MPRPresetsProperty
extends MPRProperty {
    public Mode mode;
    public Boolean applyAll;
    public List<MPRWeightedPreset> weightedPresets;

    public MPRPresetsProperty(Mode mode, Boolean applyAll, List<MPRWeightedPreset> weightedPresets, List<MPRCondition> conditions) {
        super(conditions);
        this.mode = mode;
        this.applyAll = applyAll;
        this.weightedPresets = weightedPresets;
    }

    @Override
    public boolean apply(LivingEntity living) {
        if (ModNBTData.contains((Entity)living, (ResourceLocation)MPRBase.PRESET)) {
            return false;
        }
        if (this.applyAll.booleanValue()) {
            List<MPRWeightedPreset> items = this.getPresets(living);
            items.forEach(weightedPreset -> weightedPreset.tryApply(living));
            return true;
        }
        MPRWeightedPreset weightedPreset2 = this.getRandomPreset(living);
        if (weightedPreset2 == null) {
            return false;
        }
        weightedPreset2.tryApply(living);
        return true;
    }

    private List<MPRWeightedPreset> getPresets(LivingEntity entity) {
        ArrayList<MPRWeightedPreset> weightedPresets = new ArrayList<MPRWeightedPreset>();
        for (MPRWeightedPreset weightedPreset : this.weightedPresets) {
            MPRWeightedPreset mprWeightedPreset = weightedPreset.computeAndGet(entity);
            if (mprWeightedPreset == null || !mprWeightedPreset.isValid()) continue;
            weightedPresets.add(mprWeightedPreset);
        }
        return weightedPresets;
    }

    @Nullable
    public MPRWeightedPreset getRandomPreset(LivingEntity entity) {
        List<MPRWeightedPreset> items = this.getPresets(entity);
        if (items.isEmpty()) {
            return null;
        }
        return (MPRWeightedPreset)WeightedRandom.getRandomItem((RandomSource)entity.m_9236_().f_46441_, items);
    }

    public static enum Mode {
        EXCLUSIVE,
        BEFORE,
        AFTER;

    }

    public static class Serializer
    implements JsonDeserializer<MPRPresetsProperty>,
    JsonSerializer<MPRPresetsProperty> {
        public MPRPresetsProperty deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            List<MPRWeightedPreset> presets = SerializerUtils.deserializeList(jObject, "presets", context, MPRWeightedPreset.class);
            if (presets.isEmpty()) {
                throw new JsonParseException("Presets list is empty");
            }
            return new MPRPresetsProperty((Mode)((Object)GsonHelper.m_13845_((JsonObject)jObject, (String)"mode", (Object)((Object)Mode.EXCLUSIVE), (JsonDeserializationContext)context, Mode.class)), GsonHelper.m_13855_((JsonObject)jObject, (String)"apply_all", (boolean)false), presets, MPRCondition.deserializeConditions(jObject, context));
        }

        public JsonElement serialize(MPRPresetsProperty src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            jObject.add("mode", context.serialize((Object)src.mode));
            jObject.addProperty("apply_all", src.applyAll);
            jObject.add("presets", context.serialize(src.weightedPresets));
            return src.endSerialization(jObject, context);
        }
    }
}

