/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.property;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import insane96mcp.insanelib.util.ModNBTData;
import insane96mcp.mobspropertiesrandomness.MPR;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import insane96mcp.mobspropertiesrandomness.data.json.property.MPRProperty;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.bossevents.CustomBossEvent;
import net.minecraft.server.bossevents.CustomBossEvents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@JsonAdapter(value=Serializer.class)
public class MPRBossBarProperty
extends MPRProperty {
    public static final ResourceLocation BOSS_BAR_VISIBILITY_RANGE = MPR.location("boss_bar_visibility_range");
    public static final ResourceLocation BOSS_BAR_ID = MPR.location("boss_bar_uuid");
    public BossEvent.BossBarColor color;
    public BossEvent.BossBarOverlay type;
    @SerializedName(value="darken_screen")
    public boolean darkenScreen;
    public int range;

    public MPRBossBarProperty(BossEvent.BossBarColor color, BossEvent.BossBarOverlay type, boolean darkenScreen, int range, List<MPRCondition> conditions) {
        super(conditions);
        this.color = color;
        this.type = type;
        this.darkenScreen = darkenScreen;
        this.range = range;
    }

    @Override
    public boolean apply(LivingEntity living) {
        if (living.m_20194_() == null || ModNBTData.contains((Entity)living, (ResourceLocation)BOSS_BAR_ID)) {
            return false;
        }
        MinecraftServer server = living.m_20194_();
        ResourceLocation bossBarId = MPR.location(living.m_19879_() + "_" + living.m_217043_().m_188503_(Integer.MAX_VALUE));
        CustomBossEvent bossEvent = server.m_129901_().m_136299_(bossBarId, living.m_5446_());
        bossEvent.m_6451_(this.color);
        bossEvent.m_5648_(this.type);
        bossEvent.m_7003_(this.darkenScreen);
        ModNBTData.put((Entity)living, (ResourceLocation)BOSS_BAR_ID, (Object)bossBarId.toString());
        ModNBTData.put((Entity)living, (ResourceLocation)BOSS_BAR_VISIBILITY_RANGE, (Object)this.range);
        MPRBossBarProperty.showBar((Entity)living, true);
        return true;
    }

    public static void removeBar(Entity entity) {
        if (entity.m_20194_() == null || !(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        CustomBossEvents customBossEvents = entity.m_20194_().m_129901_();
        CustomBossEvent bossEvent = MPRBossBarProperty.getBarFromEntity(living);
        if (bossEvent != null) {
            bossEvent.m_7706_();
            customBossEvents.m_136302_(bossEvent);
        }
    }

    public static void removePlayer(Entity entity, Player player) {
        LivingEntity livingEntity;
        block5: {
            block4: {
                if (player.m_9236_().f_46443_ || !(entity instanceof LivingEntity)) break block4;
                livingEntity = (LivingEntity)entity;
                if (player instanceof ServerPlayer) break block5;
            }
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        CustomBossEvent bossEvent = MPRBossBarProperty.getBarFromEntity(livingEntity);
        if (bossEvent == null) {
            return;
        }
        bossEvent.m_6539_(serverPlayer);
    }

    public static void updateBar(LivingEntity living, @NotNull CustomBossEvent bossBar) {
        bossBar.m_142711_(living.m_21223_() / living.m_21233_());
    }

    public static void updateBar(Entity entity) {
        if (entity.m_9236_().f_46443_ || !(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        CustomBossEvent bossEvent = MPRBossBarProperty.getBarFromEntity(livingEntity);
        if (bossEvent == null) {
            return;
        }
        MPRBossBarProperty.updateBar(livingEntity, bossEvent);
    }

    public static void showBar(Entity entity, boolean force) {
        LivingEntity living;
        block5: {
            block4: {
                if (!(entity instanceof LivingEntity)) break block4;
                living = (LivingEntity)entity;
                if (entity.f_19797_ % 20 == entity.m_19879_() % 20 || force) break block5;
            }
            return;
        }
        CustomBossEvent bossBar = MPRBossBarProperty.getBarFromEntity(living);
        if (bossBar == null) {
            return;
        }
        int range = (Integer)ModNBTData.get((Entity)entity, (ResourceLocation)BOSS_BAR_VISIBILITY_RANGE, Integer.class);
        bossBar.m_7706_();
        entity.m_9236_().m_6907_().stream().filter(p -> p.m_20280_(entity) < (double)(range * range)).forEach(player -> bossBar.m_6543_((ServerPlayer)player));
        bossBar.m_6456_(living.m_5446_());
    }

    @Nullable
    private static CustomBossEvent getBarFromEntity(LivingEntity entity) {
        if (entity.m_20194_() == null) {
            return null;
        }
        String bossBarId = (String)ModNBTData.get((Entity)entity, (ResourceLocation)BOSS_BAR_ID, String.class);
        if (bossBarId.isEmpty()) {
            return null;
        }
        ResourceLocation bossBarIdLocation = ResourceLocation.parse((String)bossBarId);
        CustomBossEvents customBossEvents = entity.m_20194_().m_129901_();
        return customBossEvents.m_136297_(bossBarIdLocation);
    }

    public static class Serializer
    implements JsonDeserializer<MPRBossBarProperty>,
    JsonSerializer<MPRBossBarProperty> {
        public MPRBossBarProperty deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            BossEvent.BossBarColor color = (BossEvent.BossBarColor)GsonHelper.m_13836_((JsonObject)jObject, (String)"color", (JsonDeserializationContext)context, BossEvent.BossBarColor.class);
            BossEvent.BossBarOverlay type = (BossEvent.BossBarOverlay)GsonHelper.m_13836_((JsonObject)jObject, (String)"type", (JsonDeserializationContext)context, BossEvent.BossBarOverlay.class);
            boolean darkenScreen = GsonHelper.m_13855_((JsonObject)jObject, (String)"darken_screen", (boolean)false);
            int range = GsonHelper.m_13824_((JsonObject)jObject, (String)"range", (int)48);
            return new MPRBossBarProperty(color, type, darkenScreen, range, MPRCondition.deserializeConditions(jObject, context));
        }

        public JsonElement serialize(MPRBossBarProperty src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            jObject.add("color", context.serialize((Object)src.color));
            jObject.add("type", context.serialize((Object)src.type));
            jObject.addProperty("darken_screen", Boolean.valueOf(src.darkenScreen));
            jObject.addProperty("range", (Number)src.range);
            return src.endSerialization(jObject, context);
        }
    }
}

