/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.property.equipment;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.insanelib.util.weightedrandom.IWeightedRandom;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRConditionable;
import insane96mcp.mobspropertiesrandomness.data.json.property.equipment.MPRItemFunction;
import insane96mcp.mobspropertiesrandomness.data.json.util.modifiable.MPRModifiableValue;
import insane96mcp.mobspropertiesrandomness.util.Logger;
import insane96mcp.mobspropertiesrandomness.util.SerializerUtils;
import java.lang.reflect.Type;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

@JsonAdapter(value=Serializer.class)
public class MPRItem
extends MPRConditionable
implements IWeightedRandom {
    public Item item;
    private final MPRModifiableValue modifiableWeight;
    private int _weight;
    public List<MPRItemFunction> functions;
    private boolean valid = true;
    private boolean setEmpty = true;

    public MPRItem(Item item, MPRModifiableValue modifiableWeight, List<MPRItemFunction> functions, List<MPRCondition> conditions) {
        super(conditions);
        this.item = item;
        this.modifiableWeight = modifiableWeight;
        this.functions = functions;
    }

    public ItemStack getStack(LivingEntity living, EquipmentSlot slot) {
        ItemStack stack = new ItemStack((ItemLike)this.item);
        for (MPRItemFunction function : this.functions) {
            function.tryApply(living, stack, slot);
        }
        return stack;
    }

    @Nullable
    public MPRItem computeAndGet(LivingEntity entity) {
        if (!this.valid || !MPRCondition.conditionsApply(this.conditions, entity)) {
            return null;
        }
        this._weight = (int)this.modifiableWeight.getValue(entity);
        return this;
    }

    public int getWeight() {
        return this._weight;
    }

    public boolean shouldSetEmpty() {
        return this.setEmpty;
    }

    public static class Serializer
    implements JsonSerializer<MPRItem>,
    JsonDeserializer<MPRItem> {
        public MPRItem deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            ResourceLocation itemLocation = ResourceLocation.parse((String)GsonHelper.m_13851_((JsonObject)jObject, (String)"item", (String)""));
            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemLocation);
            MPRItem mprItem = new MPRItem(item, (MPRModifiableValue)GsonHelper.m_13845_((JsonObject)jObject, (String)"weight", (Object)new MPRModifiableValue(1.0), (JsonDeserializationContext)context, MPRModifiableValue.class), MPRItemFunction.deserializeList(jObject, "functions", context), MPRCondition.deserializeConditions(jObject, context));
            if (itemLocation.toString().equals("minecraft:air")) {
                mprItem.setEmpty = true;
            } else if (item == Items.f_41852_) {
                Logger.warn("Invalid item: %s. Ignored.", itemLocation);
                mprItem.valid = false;
            }
            return mprItem;
        }

        public JsonElement serialize(MPRItem src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = context.serialize(src.functions).getAsJsonObject();
            jObject.add("item", SerializerUtils.serializeRegistryObject(src.item, Registries.f_256913_));
            jObject.add("weight", context.serialize((Object)src.modifiableWeight));
            return src.endSerialization(jObject, context);
        }
    }
}

