/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.property;

import com.google.common.collect.HashMultimap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.insanelib.util.ModNBTData;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import insane96mcp.mobspropertiesrandomness.data.json.property.MPRProperty;
import insane96mcp.mobspropertiesrandomness.data.json.util.modifiable.MPRRange;
import insane96mcp.mobspropertiesrandomness.util.SerializerUtils;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.apache.logging.log4j.util.TriConsumer;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;

@JsonAdapter(value=Serializer.class)
public class MPRScalePehkuiProperty
extends MPRProperty {
    public static final ResourceLocation SCALE_PEHKUI_APPLIED = ResourceLocation.fromNamespaceAndPath((String)"mobspropertiesrandomness", (String)"scale_pehkui_applied");
    public MPRRange scale;
    public List<ResourceLocation> scaleTypes;
    public Operation operation;
    private static final HashMultimap<LivingEntity, MPRScalePehkuiProperty> TO_APPLY = HashMultimap.create();

    public MPRScalePehkuiProperty(MPRRange scale, List<ResourceLocation> scaleTypes, Operation operation, List<MPRCondition> conditions) {
        super(conditions);
        this.scale = scale;
        this.scaleTypes = scaleTypes;
        this.operation = operation;
    }

    @Override
    public boolean apply(LivingEntity living) {
        TO_APPLY.put((Object)living, (Object)this);
        return true;
    }

    public static void applyScheduled(LivingEntity entity) {
        TO_APPLY.get((Object)entity).forEach(mprScalePehkui -> mprScalePehkui.actuallyApply(entity));
        ModNBTData.put((Entity)entity, (ResourceLocation)SCALE_PEHKUI_APPLIED, (Object)true);
        TO_APPLY.removeAll((Object)entity);
    }

    public void actuallyApply(LivingEntity living) {
        double scale = this.scale.getDoubleBetween(living);
        for (ResourceLocation scaleType : this.scaleTypes) {
            ScaleType type = (ScaleType)ScaleRegistries.SCALE_TYPES.get((Object)scaleType);
            ScaleData scaleData = type.getScaleData((Entity)living);
            this.operation.applyScale(scaleData, Float.valueOf((float)scale), living);
        }
    }

    public static enum Operation {
        SET((TriConsumer<ScaleData, Float, LivingEntity>)((TriConsumer)(scaleData, scale, entity) -> scaleData.setScale(scale.floatValue()))),
        ADD((TriConsumer<ScaleData, Float, LivingEntity>)((TriConsumer)(scaleData, scale, entity) -> scaleData.setScale(scaleData.getScale() + scale.floatValue()))),
        MULTIPLY((TriConsumer<ScaleData, Float, LivingEntity>)((TriConsumer)(scaleData, scale, entity) -> scaleData.setScale(scaleData.getScale() * scale.floatValue())));

        final TriConsumer<ScaleData, Float, LivingEntity> apply;

        private Operation(TriConsumer<ScaleData, Float, LivingEntity> apply) {
            this.apply = apply;
        }

        public void applyScale(ScaleData scaleData, Float mprRange, LivingEntity entity) {
            this.apply.accept((Object)scaleData, (Object)mprRange, (Object)entity);
        }
    }

    public static class Serializer
    implements JsonDeserializer<MPRScalePehkuiProperty>,
    JsonSerializer<MPRScalePehkuiProperty> {
        public MPRScalePehkuiProperty deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            return new MPRScalePehkuiProperty((MPRRange)context.deserialize(jObject.get("scale"), MPRRange.class), SerializerUtils.deserializeLocationList(jObject, "scale_types", context), (Operation)((Object)GsonHelper.m_13836_((JsonObject)jObject, (String)"operation", (JsonDeserializationContext)context, Operation.class)), MPRCondition.deserializeConditions(jObject, context));
        }

        public JsonElement serialize(MPRScalePehkuiProperty src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            jObject.add("scale", context.serialize((Object)src.scale));
            SerializerUtils.serializeLocationList(jObject, "scale_types", context, src.scaleTypes);
            jObject.add("operation", context.serialize((Object)src.operation));
            return src.endSerialization(jObject, context);
        }
    }
}

