/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.property.equipment;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.mobspropertiesrandomness.MPR;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRConditionable;
import insane96mcp.mobspropertiesrandomness.data.json.property.equipment.MPRItemFunction;
import insane96mcp.mobspropertiesrandomness.data.json.util.modifiable.MPRRange;
import insane96mcp.mobspropertiesrandomness.util.SerializerUtils;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraftforge.registries.ForgeRegistries;

@JsonAdapter(value=Serializer.class)
public abstract class MPREnchantItemFunction
extends MPRItemFunction {
    public static final Map<ResourceLocation, Class<? extends MPREnchantItemFunction>> TYPES = Map.of(MPR.location("single"), SingleEnchantment.class, MPR.location("random"), RandomEnchantment.class, MPR.location("with_levels"), WithLevel.class);
    @Nullable
    public MPRRange level;
    public boolean allowIncompatible;

    public MPREnchantItemFunction(@Nullable MPRRange level, boolean allowIncompatible, List<MPRCondition> conditions) {
        super(conditions);
        this.level = level;
        this.allowIncompatible = allowIncompatible;
    }

    public int getLvl(LivingEntity entity, Enchantment enchantment) {
        int minLevel = this.level != null ? (int)this.level.getMin(entity) : enchantment.m_44702_();
        int maxLevel = this.level != null ? (int)this.level.getMax(entity) : enchantment.m_6586_();
        return Mth.m_216271_((RandomSource)entity.m_9236_().f_46441_, (int)minLevel, (int)maxLevel);
    }

    private static void addEnchantmentToItemStack(ItemStack itemStack, Enchantment enchantment, int lvl) {
        if (itemStack.m_41720_() == Items.f_42690_) {
            EnchantedBookItem.m_41153_((ItemStack)itemStack, (EnchantmentInstance)new EnchantmentInstance(enchantment, lvl));
        } else {
            itemStack.m_41663_(enchantment, lvl);
        }
    }

    private static void removeEnchantmentFromItemStack(ItemStack stack, Enchantment enchantment) {
        if (stack.m_41783_() == null) {
            return;
        }
        ListTag listTag = new ListTag();
        if (stack.m_41783_().m_128441_("Enchantments")) {
            listTag = stack.m_41783_().m_128437_("Enchantments", 10);
        } else if (stack.m_41720_() == Items.f_42690_) {
            listTag = EnchantedBookItem.m_41163_((ItemStack)stack);
        }
        if (listTag.isEmpty()) {
            return;
        }
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag compound = listTag.m_128728_(i);
            Enchantment foundEnchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(EnchantmentHelper.m_182446_((CompoundTag)compound));
            if (foundEnchantment != enchantment) continue;
            listTag.remove(i);
            return;
        }
    }

    @Nullable
    public static MPRRange deserializeLvl(JsonObject jObject, JsonDeserializationContext context) {
        if (!jObject.has("lvl")) {
            return null;
        }
        return (MPRRange)GsonHelper.m_13836_((JsonObject)jObject, (String)"lvl", (JsonDeserializationContext)context, MPRRange.class);
    }

    public static boolean deserializeAllowIncompatible(JsonObject jObject) {
        return GsonHelper.m_13855_((JsonObject)jObject, (String)"allow_incompatible", (boolean)false);
    }

    @Override
    public JsonObject endSerialization(JsonObject jObject, JsonSerializationContext context) {
        if (this.level != null) {
            jObject.add("lvl", context.serialize((Object)this.level));
        }
        if (this.allowIncompatible) {
            jObject.addProperty("allow_incompatible", Boolean.valueOf(true));
        }
        return super.endSerialization(jObject, context);
    }

    @JsonAdapter(value=Serializer.class)
    public static class SingleEnchantment
    extends MPREnchantItemFunction {
        public Enchantment enchantment;

        public SingleEnchantment(Enchantment enchantment, MPRRange level, boolean allowIncompatible, List<MPRCondition> conditions) {
            super(level, allowIncompatible, conditions);
            this.enchantment = enchantment;
        }

        @Override
        protected boolean apply(LivingEntity living, ItemStack stack, EquipmentSlot slot) {
            boolean canApply;
            Map enchantmentsOnStack = EnchantmentHelper.m_44831_((ItemStack)stack);
            boolean bl = canApply = this.allowIncompatible || EnchantmentHelper.m_44859_(enchantmentsOnStack.keySet(), (Enchantment)this.enchantment);
            if (!canApply) {
                return false;
            }
            int lvl = this.getLvl(living, this.enchantment);
            if (this.enchantment != null) {
                MPREnchantItemFunction.addEnchantmentToItemStack(stack, this.enchantment, lvl);
            }
            return true;
        }

        public static class Serializer
        implements JsonSerializer<SingleEnchantment>,
        JsonDeserializer<SingleEnchantment> {
            public SingleEnchantment deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jObject = json.getAsJsonObject();
                return new SingleEnchantment((Enchantment)SerializerUtils.deserializeRegistryObject(jObject, "enchantment", Registries.f_256762_), MPREnchantItemFunction.deserializeLvl(jObject, context), MPREnchantItemFunction.deserializeAllowIncompatible(jObject), MPRConditionable.deserializeList(jObject, context));
            }

            public JsonElement serialize(SingleEnchantment src, Type typeOfSrc, JsonSerializationContext context) {
                JsonObject jObject = new JsonObject();
                jObject.add("enchantment", SerializerUtils.serializeRegistryObject(src.enchantment, Registries.f_256762_));
                return src.endSerialization(jObject, context);
            }
        }
    }

    @JsonAdapter(value=Serializer.class)
    public static class RandomEnchantment
    extends MPREnchantItemFunction {
        public boolean allowCurses;
        public boolean allowTreasure;
        public List<Enchantment> enchantments;

        public RandomEnchantment(boolean allowCurses, boolean allowTreasure, List<Enchantment> enchantments, MPRRange level, boolean allowIncompatible, List<MPRCondition> conditions) {
            super(level, allowIncompatible, conditions);
            this.allowCurses = allowCurses;
            this.allowTreasure = allowTreasure;
            this.enchantments = enchantments;
        }

        @Override
        protected boolean apply(LivingEntity living, ItemStack stack, EquipmentSlot slot) {
            Map enchantmentsOnStack = EnchantmentHelper.m_44831_((ItemStack)stack);
            boolean isBook = stack.m_41720_() == Items.f_42690_;
            List<Enchantment> possibleEnchantments = ForgeRegistries.ENCHANTMENTS.getValues().stream().filter(enchantment -> {
                if (!enchantment.m_6592_() || enchantment.m_6589_() && !this.allowCurses || enchantment.m_6591_() && !this.allowTreasure || !this.enchantments.isEmpty() && !this.enchantments.contains(enchantment)) {
                    return false;
                }
                if (!this.allowIncompatible) {
                    for (Enchantment enchantmentOnStack : enchantmentsOnStack.keySet()) {
                        if (enchantment.m_44695_(enchantmentOnStack)) continue;
                        return false;
                    }
                }
                return isBook || enchantment.m_6081_(stack);
            }).toList();
            if (possibleEnchantments.isEmpty()) {
                return false;
            }
            Enchantment enchantment2 = possibleEnchantments.get(living.m_217043_().m_188503_(possibleEnchantments.size()));
            MPREnchantItemFunction.addEnchantmentToItemStack(stack, enchantment2, this.getLvl(living, enchantment2));
            return true;
        }

        public static class Serializer
        implements JsonSerializer<RandomEnchantment>,
        JsonDeserializer<RandomEnchantment> {
            public RandomEnchantment deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jObject = json.getAsJsonObject();
                return new RandomEnchantment(GsonHelper.m_13855_((JsonObject)jObject, (String)"allow_curses", (boolean)true), GsonHelper.m_13855_((JsonObject)jObject, (String)"allow_treasure", (boolean)true), SerializerUtils.deserializeRegistryObjectList(jObject, "enchantments", context, Registries.f_256762_), MPREnchantItemFunction.deserializeLvl(jObject, context), MPREnchantItemFunction.deserializeAllowIncompatible(jObject), MPRConditionable.deserializeList(jObject, context));
            }

            public JsonElement serialize(RandomEnchantment src, Type typeOfSrc, JsonSerializationContext context) {
                JsonObject jObject = new JsonObject();
                if (!src.allowCurses) {
                    jObject.addProperty("allow_curses", Boolean.valueOf(false));
                }
                if (!src.allowTreasure) {
                    jObject.addProperty("allow_treasure", Boolean.valueOf(false));
                }
                jObject.add("enchantments", (JsonElement)SerializerUtils.serializeRegistryObjectList(jObject, src.enchantments, context, Registries.f_256762_));
                return src.endSerialization(jObject, context);
            }
        }
    }

    @JsonAdapter(value=Serializer.class)
    public static class WithLevel
    extends MPREnchantItemFunction {
        public boolean allowTreasure;
        public boolean allowCurses;

        public WithLevel(boolean allowCurses, boolean allowTreasure, MPRRange level, boolean allowIncompatible, List<MPRCondition> conditions) {
            super(level, allowIncompatible, conditions);
            this.allowCurses = allowCurses;
            this.allowTreasure = allowTreasure;
        }

        @Override
        protected boolean apply(LivingEntity living, ItemStack stack, EquipmentSlot slot) {
            int lvl = Math.max(1, this.getLvl(living, null));
            List list = EnchantmentHelper.m_220297_((RandomSource)living.m_9236_().f_46441_, (ItemStack)stack, (int)lvl, (boolean)true);
            for (EnchantmentInstance instance : list) {
                int lvlOnStack;
                if (instance.f_44947_.m_6589_() && !this.allowCurses || instance.f_44947_.m_6591_() && !this.allowTreasure || (lvlOnStack = stack.getEnchantmentLevel(instance.f_44947_)) >= instance.f_44948_) continue;
                if (lvlOnStack == 0) {
                    MPREnchantItemFunction.addEnchantmentToItemStack(stack, instance.f_44947_, instance.f_44948_);
                    continue;
                }
                MPREnchantItemFunction.removeEnchantmentFromItemStack(stack, instance.f_44947_);
                MPREnchantItemFunction.addEnchantmentToItemStack(stack, instance.f_44947_, instance.f_44948_);
            }
            return true;
        }

        public static class Serializer
        implements JsonSerializer<WithLevel>,
        JsonDeserializer<WithLevel> {
            public WithLevel deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                JsonObject jObject = json.getAsJsonObject();
                return new WithLevel(GsonHelper.m_13855_((JsonObject)jObject, (String)"allow_curses", (boolean)true), GsonHelper.m_13855_((JsonObject)jObject, (String)"allow_treasure", (boolean)true), MPREnchantItemFunction.deserializeLvl(jObject, context), MPREnchantItemFunction.deserializeAllowIncompatible(jObject), MPRConditionable.deserializeList(jObject, context));
            }

            public JsonElement serialize(WithLevel src, Type typeOfSrc, JsonSerializationContext context) {
                JsonObject jObject = new JsonObject();
                if (!src.allowCurses) {
                    jObject.addProperty("allow_curses", Boolean.valueOf(false));
                }
                if (!src.allowTreasure) {
                    jObject.addProperty("allow_treasure", Boolean.valueOf(false));
                }
                return src.endSerialization(jObject, context);
            }
        }
    }

    public static class Serializer
    implements JsonSerializer<MPREnchantItemFunction>,
    JsonDeserializer<MPREnchantItemFunction> {
        public MPREnchantItemFunction deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            ResourceLocation propertyId = MPR.locationFrom(GsonHelper.m_13906_((JsonObject)jObject, (String)"type"));
            Type propertyType = TYPES.get(propertyId);
            if (propertyType == null) {
                throw new JsonParseException("enchantment type %s does not exist. Skipping".formatted(propertyId));
            }
            return (MPREnchantItemFunction)context.deserialize((JsonElement)jObject, propertyType);
        }

        public JsonElement serialize(MPREnchantItemFunction src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = context.serialize((Object)src).getAsJsonObject();
            for (Map.Entry<ResourceLocation, Class<? extends MPREnchantItemFunction>> type : TYPES.entrySet()) {
                if (!type.getValue().isInstance(src)) continue;
                jObject.addProperty("type", type.getKey().toString());
                break;
            }
            return jObject;
        }
    }
}

