/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public class SerializerUtils {
    public static <T> List<T> deserializeList(JsonObject jObject, String memberName, JsonDeserializationContext context, Class<T> clazz) throws JsonParseException {
        return SerializerUtils.deserializeList(jObject, memberName, context, clazz, true);
    }

    public static <T> List<T> deserializeList(JsonObject jObject, String memberName, JsonDeserializationContext context, Class<T> clazz, boolean required) throws JsonParseException {
        if (!jObject.has(memberName)) {
            if (required) {
                throw new JsonParseException("Missing %s array".formatted(memberName));
            }
            return new ArrayList();
        }
        if (jObject.get(memberName).isJsonObject()) {
            return Collections.singletonList(context.deserialize((JsonElement)jObject.get(memberName).getAsJsonObject(), clazz));
        }
        if (jObject.get(memberName).isJsonPrimitive()) {
            return Collections.singletonList(context.deserialize(jObject.get(memberName), clazz));
        }
        if (jObject.get(memberName).isJsonArray()) {
            JsonArray jsonArray = jObject.getAsJsonArray(memberName);
            if (jsonArray == null) {
                return new ArrayList();
            }
            ArrayList<Object> list = new ArrayList<Object>();
            for (JsonElement el : jsonArray) {
                Object item = context.deserialize(el, clazz);
                list.add(item);
            }
            return list;
        }
        throw new JsonParseException("Expected %s to be a JsonObject or JsonArray".formatted(memberName));
    }

    public static <T> List<T> deserializeList(JsonArray jArray, JsonDeserializationContext context, Class<T> clazz) throws JsonParseException {
        if (jArray == null) {
            return new ArrayList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (JsonElement el : jArray) {
            Object item = context.deserialize(el, clazz);
            list.add(item);
        }
        return list;
    }

    public static JsonArray serializeList(List<?> list, JsonSerializationContext context) throws JsonParseException {
        JsonArray jsonArray = new JsonArray();
        for (Object item : list) {
            jsonArray.add(context.serialize(item));
        }
        return jsonArray;
    }

    public static List<ResourceLocation> deserializeLocationList(JsonObject jObject, String memberName, JsonDeserializationContext context) throws JsonParseException {
        List<String> list = SerializerUtils.deserializeList(jObject, memberName, context, String.class);
        ArrayList<ResourceLocation> locations = new ArrayList<ResourceLocation>(list.size());
        for (String loc : list) {
            locations.add(ResourceLocation.parse((String)loc));
        }
        return locations;
    }

    public static void serializeLocationList(JsonObject jObject, String memberName, JsonSerializationContext context, List<ResourceLocation> list) {
        JsonArray jsonArray = new JsonArray();
        for (ResourceLocation loc : list) {
            jsonArray.add(loc.toString());
        }
        jObject.add(memberName, (JsonElement)jsonArray);
    }

    @Nullable
    public static <T> T deserializeRegistryObject(JsonElement jElement, ResourceKey<Registry<T>> registry) throws JsonParseException {
        if (!jElement.isJsonPrimitive()) {
            throw new JsonParseException("Expected %s to be a string".formatted(jElement));
        }
        Registry reg = (Registry)BuiltInRegistries.f_257047_.m_7745_(registry.m_135782_());
        if (reg == null) {
            throw new JsonParseException("Unknown registry %s".formatted(registry.m_135782_()));
        }
        ResourceLocation objectId = ResourceLocation.parse((String)jElement.getAsString());
        return (T)reg.m_7745_(objectId);
    }

    @Nullable
    public static <T> T deserializeRegistryObject(JsonObject jObject, String memberName, ResourceKey<Registry<T>> registry) throws JsonParseException {
        if (!jObject.has(memberName)) {
            throw new JsonParseException("Missing \"%s\" from %s".formatted(memberName, jObject));
        }
        return SerializerUtils.deserializeRegistryObject(jObject.get(memberName), registry);
    }

    public static <T> List<T> deserializeRegistryObjectList(JsonObject jObject, String memberName, JsonDeserializationContext context, ResourceKey<Registry<T>> registry) throws JsonParseException {
        if (!jObject.has(memberName)) {
            throw new JsonParseException("Missing %s array".formatted(memberName));
        }
        JsonArray jsonArray = jObject.getAsJsonArray(memberName);
        if (jsonArray == null) {
            return new ArrayList();
        }
        ArrayList<T> objects = new ArrayList<T>();
        for (JsonElement el : jsonArray) {
            objects.add(SerializerUtils.deserializeRegistryObject(el, registry));
        }
        return objects;
    }

    public static <T> JsonElement serializeRegistryObject(T object, ResourceKey<Registry<T>> registry) throws JsonParseException {
        Registry reg = (Registry)BuiltInRegistries.f_257047_.m_7745_(registry.m_135782_());
        if (reg == null) {
            throw new JsonParseException("Unknown registry %s".formatted(registry.m_135782_()));
        }
        ResourceLocation objectId = reg.m_7981_(object);
        if (objectId == null) {
            throw new JsonParseException("Object %s not found in registry %s".formatted(object, registry.m_135782_()));
        }
        return new JsonPrimitive(objectId.toString());
    }

    public static <T> JsonArray serializeRegistryObjectList(JsonObject jObject, List<T> objectsList, JsonSerializationContext context, ResourceKey<Registry<T>> registry) throws JsonParseException {
        JsonArray jsonArray = new JsonArray();
        for (T object : objectsList) {
            jsonArray.add(SerializerUtils.serializeRegistryObject(object, registry));
        }
        return jsonArray;
    }
}

