/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import insane96mcp.mobspropertiesrandomness.MPR;
import insane96mcp.mobspropertiesrandomness.data.json.MPRProperties;
import insane96mcp.mobspropertiesrandomness.data.json.property.events.MPREvent;
import insane96mcp.mobspropertiesrandomness.data.json.property.preset.MPRPresetsProperty;
import insane96mcp.mobspropertiesrandomness.data.json.property.preset.MPRWeightedPreset;
import insane96mcp.mobspropertiesrandomness.util.Logger;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MPRPresetReloadListener
extends SimplePreparableReloadListener<Map<ResourceLocation, JsonElement>> {
    public static final Map<ResourceLocation, MPRProperties> PRESETS = new HashMap<ResourceLocation, MPRProperties>();
    public static final MPRPresetReloadListener INSTANCE;
    private static final Gson GSON;
    private final String directory;

    public MPRPresetReloadListener() {
        this.directory = "mobs_properties_randomness/presets";
    }

    @NotNull
    protected Map<ResourceLocation, JsonElement> prepare(@NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        HashMap<ResourceLocation, JsonElement> map = new HashMap<ResourceLocation, JsonElement>();
        MPRPresetReloadListener.scanDirectory(resourceManager, this.directory, GSON, map);
        return map;
    }

    public static void scanDirectory(ResourceManager resourceManager, String directory, Gson gson, Map<ResourceLocation, JsonElement> map) {
        FileToIdConverter filetoidconverter = FileToIdConverter.m_246568_((String)directory);
        MPREvent.LOADED_EVENTS.clear();
        for (Map.Entry entry : filetoidconverter.m_247457_(resourceManager).entrySet()) {
            ResourceLocation key = (ResourceLocation)entry.getKey();
            ResourceLocation id = filetoidconverter.m_245273_(key);
            try {
                BufferedReader reader = ((Resource)entry.getValue()).m_215508_();
                try {
                    JsonElement jsonElement = (JsonElement)GsonHelper.m_13776_((Gson)gson, (Reader)reader, JsonElement.class);
                    JsonElement duplicated = map.put(id, jsonElement);
                    if (duplicated == null) continue;
                    throw new IllegalStateException("Duplicate data file with ID " + String.valueOf(id));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Exception exception) {
                Logger.error("Error loading Preset %s: %s", key, exception.getMessage());
            }
        }
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> map, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        PRESETS.clear();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            try {
                ResourceLocation name = entry.getKey();
                Logger.info("Loading Preset %s", entry.getKey());
                String[] split = name.m_135815_().split("/");
                if (split[split.length - 1].startsWith("_")) continue;
                MPRProperties preset2 = (MPRProperties)GSON.fromJson(entry.getValue(), MPRProperties.class);
                if (preset2.getProperties().isEmpty()) {
                    throw new IllegalStateException("Preset has no properties");
                }
                PRESETS.put(name, preset2);
            }
            catch (JsonSyntaxException e) {
                Logger.error("Parsing error loading Preset %s: %s", entry.getKey(), e.getMessage());
            }
            catch (Exception e) {
                Logger.error("Failed loading Preset %s: %s", entry.getKey(), e.getMessage());
            }
        }
        PRESETS.forEach((id, preset) -> preset.getProperties().forEach(property -> {
            if (property instanceof MPRPresetsProperty) {
                MPRPresetsProperty mprPresetsProperty = (MPRPresetsProperty)property;
                Logger.info("Resolving presets-in-presets for %s", id);
                mprPresetsProperty.weightedPresets.forEach(MPRWeightedPreset::resolve);
            }
        }));
        Logger.info("Loaded %s Presets", PRESETS.size());
    }

    @Nullable
    public static ResourceLocation getKey(@NotNull MPRProperties preset) {
        for (Map.Entry<ResourceLocation, MPRProperties> entry : PRESETS.entrySet()) {
            if (!entry.getValue().equals(preset)) continue;
            return entry.getKey();
        }
        return null;
    }

    static {
        GSON = MPR.createGson();
        INSTANCE = new MPRPresetReloadListener();
    }
}

