/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import insane96mcp.mobspropertiesrandomness.util.SerializerUtils;
import java.lang.reflect.Type;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

@JsonAdapter(value=Serializer.class)
public class MPREquipmentCondition
extends MPRCondition {
    public EquipmentSlot slot;
    @Nullable
    public List<Item> items;
    @Nullable
    public TagKey<Item> itemTag;

    public MPREquipmentCondition(EquipmentSlot slot, @Nullable List<Item> items, @Nullable TagKey<Item> itemTag, boolean inverted) {
        super(inverted);
        this.slot = slot;
        this.items = items;
        this.itemTag = itemTag;
    }

    @Override
    protected boolean conditionCheck(LivingEntity living) {
        ItemStack itemBySlot = living.m_6844_(this.slot);
        if (this.itemTag != null) {
            return itemBySlot.m_204117_(this.itemTag);
        }
        if (this.items != null) {
            for (Item item : this.items) {
                if (!itemBySlot.m_150930_(item)) continue;
                return true;
            }
        }
        return false;
    }

    public static class Serializer
    implements JsonDeserializer<MPREquipmentCondition>,
    JsonSerializer<MPREquipmentCondition> {
        public MPREquipmentCondition deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            if (!jObject.has("items")) {
                throw new JsonParseException("missing 'items'");
            }
            EquipmentSlot slot = (EquipmentSlot)GsonHelper.m_13836_((JsonObject)jObject, (String)"slot", (JsonDeserializationContext)context, EquipmentSlot.class);
            boolean inverted = MPRCondition.deserializeInverted(jObject);
            JsonElement itemsElement = jObject.get("items");
            if (itemsElement.isJsonPrimitive()) {
                String itemsString = itemsElement.getAsString();
                if (itemsString.startsWith("#")) {
                    TagKey itemTag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)ResourceLocation.parse((String)itemsString.substring(1)));
                    return new MPREquipmentCondition(slot, null, (TagKey<Item>)itemTag, inverted);
                }
                List<Item> items = List.of((Item)SerializerUtils.deserializeRegistryObject(jObject, "items", Registries.f_256913_));
                return new MPREquipmentCondition(slot, items, null, inverted);
            }
            if (itemsElement.isJsonArray()) {
                List<Item> items = SerializerUtils.deserializeRegistryObjectList(jObject, "items", context, Registries.f_256913_);
                return new MPREquipmentCondition(slot, items, null, inverted);
            }
            throw new JsonParseException("'items' must be a string or an array");
        }

        public JsonElement serialize(MPREquipmentCondition src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            jObject.add("slot", context.serialize((Object)src.slot));
            jObject.add("items", (JsonElement)SerializerUtils.serializeRegistryObjectList(jObject, src.items, context, Registries.f_256913_));
            return src.endSerialization(jObject);
        }
    }
}

