/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.condition;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import insane96mcp.mobspropertiesrandomness.data.json.util.PlayerMode;
import insane96mcp.mobspropertiesrandomness.data.json.util.modifiable.MPRRange;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

@JsonAdapter(value=Serializer.class)
public class MPRTimePlayedCondition
extends MPRCondition {
    protected MPRRange minutesPlayed;
    protected PlayerMode mode;

    public MPRTimePlayedCondition(MPRRange minutesPlayed, PlayerMode mode, boolean inverted) {
        super(inverted);
        this.minutesPlayed = minutesPlayed;
        this.mode = mode;
    }

    @Override
    protected boolean conditionCheck(LivingEntity living) {
        List<ServerPlayer> players = new ArrayList();
        if (this.mode == PlayerMode.NEAREST) {
            ServerPlayer nearestPlayer = (ServerPlayer)living.m_9236_().m_45930_((Entity)living, 128.0);
            if (nearestPlayer == null) {
                return false;
            }
            players.add(nearestPlayer);
        } else {
            players = living.m_9236_().m_45976_(ServerPlayer.class, living.m_20191_().m_82400_(128.0));
            if (players.isEmpty()) {
                return false;
            }
        }
        int ticksPlayed = ((ServerPlayer)players.get(0)).m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_144255_));
        double minutesPlayed = (double)ticksPlayed / 20.0 / 60.0;
        return this.minutesPlayed.isBetween(living, minutesPlayed);
    }

    public static class Serializer
    implements JsonDeserializer<MPRTimePlayedCondition>,
    JsonSerializer<MPRTimePlayedCondition> {
        public MPRTimePlayedCondition deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            PlayerMode playerMode = PlayerMode.NEAREST;
            if (jObject.has("player")) {
                playerMode = (PlayerMode)((Object)context.deserialize(jObject.get("player"), PlayerMode.class));
            }
            return new MPRTimePlayedCondition((MPRRange)GsonHelper.m_13836_((JsonObject)jObject, (String)"minutes_played", (JsonDeserializationContext)context, MPRRange.class), playerMode, MPRCondition.deserializeInverted(jObject));
        }

        public JsonElement serialize(MPRTimePlayedCondition src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            jObject.add("minutes_played", context.serialize((Object)src.minutesPlayed));
            jObject.add("player", context.serialize((Object)src.minutesPlayed));
            return src.endSerialization(jObject);
        }
    }
}

