/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.property;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import insane96mcp.mobspropertiesrandomness.data.json.property.MPRProperty;
import insane96mcp.mobspropertiesrandomness.util.SerializerUtils;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;

@JsonAdapter(value=Serializer.class)
public class MPRCustomNameProperty
extends MPRProperty {
    public List<String> overrides;
    public List<String> prefixes;
    public List<String> suffixes;

    public MPRCustomNameProperty(List<String> overrides, List<String> prefixes, List<String> suffixes, List<MPRCondition> conditions) {
        super(conditions);
        this.overrides = overrides;
        this.prefixes = prefixes;
        this.suffixes = suffixes;
    }

    @Override
    public boolean apply(LivingEntity living) {
        String prefix = "";
        if (this.prefixes != null && !this.prefixes.isEmpty()) {
            prefix = this.prefixes.get(living.m_217043_().m_188503_(this.prefixes.size()));
        }
        String suffix = "";
        if (this.suffixes != null && !this.suffixes.isEmpty()) {
            suffix = this.suffixes.get(living.m_217043_().m_188503_(this.suffixes.size()));
        }
        MutableComponent component = this.overrides != null && !this.overrides.isEmpty() ? Component.m_237113_((String)(prefix + this.overrides.get(living.m_217043_().m_188503_(this.overrides.size())) + suffix)) : Component.m_237113_((String)prefix).m_7220_(living.m_7755_()).m_130946_(suffix);
        living.m_6593_((Component)component);
        return true;
    }

    public static class Serializer
    implements JsonDeserializer<MPRCustomNameProperty>,
    JsonSerializer<MPRCustomNameProperty> {
        public MPRCustomNameProperty deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            List<String> overrides = SerializerUtils.deserializeList(jObject, "overrides", context, String.class, false);
            List<String> prefixes = SerializerUtils.deserializeList(jObject, "prefixes", context, String.class, false);
            List<String> suffixes = SerializerUtils.deserializeList(jObject, "suffixes", context, String.class, false);
            if (overrides.isEmpty() && prefixes.isEmpty() && suffixes.isEmpty()) {
                throw new JsonParseException("No overrides, prefixes or suffixes specified for Custom Name Property");
            }
            return new MPRCustomNameProperty(overrides, prefixes, suffixes, MPRCondition.deserializeConditions(jObject, context));
        }

        public JsonElement serialize(MPRCustomNameProperty src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            if (!src.overrides.isEmpty()) {
                jObject.add("overrides", context.serialize(src.overrides));
            }
            if (!src.prefixes.isEmpty()) {
                jObject.add("prefixes", context.serialize(src.prefixes));
            }
            if (!src.suffixes.isEmpty()) {
                jObject.add("suffixes", context.serialize(src.suffixes));
            }
            return src.endSerialization(jObject, context);
        }
    }
}

