/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.property.events;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import insane96mcp.mobspropertiesrandomness.data.json.property.MPRProperty;
import insane96mcp.mobspropertiesrandomness.data.json.property.events.MPREvent;
import insane96mcp.mobspropertiesrandomness.data.json.property.events.MPRHurtData;
import insane96mcp.mobspropertiesrandomness.data.json.property.events.Target;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import org.jetbrains.annotations.Nullable;

@JsonAdapter(value=Serializer.class)
public class MPRDeathEvent
extends MPREvent {
    public MPRHurtData hurtData;
    public boolean cancelDeath;

    public MPRDeathEvent(MPRHurtData hurtData, boolean cancelDeath, ResourceLocation id, Target target, @Nullable List<MPRProperty> applyProperties, List<MPRCondition> conditions) {
        super(id, target, applyProperties, conditions);
        this.hurtData = hurtData;
        this.cancelDeath = cancelDeath;
    }

    public boolean death(LivingEntity entity, @Nullable LivingEntity other, DamageSource source, boolean isDirectDamage) {
        if (!this.hurtData.shouldApply(source, isDirectDamage)) {
            return false;
        }
        return this.tryExecute(entity, other) && this.cancelDeath;
    }

    public static void onDeath(LivingDeathEvent event) {
        LivingEntity living = event.getEntity();
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity killer = (LivingEntity)entity;
        List<MPRDeathEvent> events = MPRDeathEvent.getEvents(living, MPRDeathEvent.class);
        for (MPRDeathEvent deathEvent : events) {
            if (!deathEvent.death(living, killer, event.getSource(), event.getSource().m_7640_() == event.getSource().m_7639_()) || event.getSource().m_269533_(DamageTypeTags.f_268738_)) continue;
            event.setCanceled(true);
            living.m_21153_(0.01f);
        }
    }

    public static class Serializer
    implements JsonDeserializer<MPRDeathEvent>,
    JsonSerializer<MPRDeathEvent> {
        public MPRDeathEvent deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            String id = GsonHelper.m_13906_((JsonObject)jObject, (String)"id");
            Target target = (Target)((Object)GsonHelper.m_13836_((JsonObject)jObject, (String)"target", (JsonDeserializationContext)context, Target.class));
            List<MPRCondition> conditions = MPRCondition.deserializeConditions(jObject, context);
            List<MPRProperty> properties = MPRProperty.deserializeList(jObject, "apply_properties", context);
            return new MPRDeathEvent(MPRHurtData.deserialize(jObject, context), GsonHelper.m_13855_((JsonObject)jObject, (String)"cancel_death", (boolean)false), ResourceLocation.parse((String)id), target, properties, conditions);
        }

        public JsonElement serialize(MPRDeathEvent src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            jObject.add("hurt_data", context.serialize((Object)src.hurtData));
            if (src.cancelDeath) {
                jObject.addProperty("cancel_death", Boolean.valueOf(true));
            }
            return src.endSerialization(jObject, context, false);
        }
    }
}

