/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.property.events;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import insane96mcp.insanelib.util.ModNBTData;
import insane96mcp.mobspropertiesrandomness.MPR;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRConditionable;
import insane96mcp.mobspropertiesrandomness.data.json.property.MPRProperty;
import insane96mcp.mobspropertiesrandomness.data.json.property.MPRScalePehkuiProperty;
import insane96mcp.mobspropertiesrandomness.data.json.property.events.EventsRegistry;
import insane96mcp.mobspropertiesrandomness.data.json.property.events.Target;
import insane96mcp.mobspropertiesrandomness.util.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public abstract class MPREvent
extends MPRConditionable {
    public static final HashMap<ResourceLocation, MPREvent> LOADED_EVENTS = new HashMap();
    public ResourceLocation id;
    public Target target;
    public List<MPRProperty> applyProperties;

    public MPREvent(ResourceLocation id, Target target, List<MPRProperty> applyProperties, List<MPRCondition> conditions) {
        super(conditions);
        this.id = id;
        this.target = target;
        this.applyProperties = applyProperties;
        if (!LOADED_EVENTS.containsKey(id)) {
            LOADED_EVENTS.put(id, this);
        }
    }

    public boolean apply(LivingEntity living) {
        ResourceLocation eventId = MPREvent.getId(this.getClass());
        if (eventId == null) {
            return false;
        }
        ListTag list = ModNBTData.getList((Entity)living, (ResourceLocation)eventId, (int)8);
        list.add((Object)StringTag.m_129297_((String)this.id.toString()));
        ModNBTData.put((Entity)living, (ResourceLocation)eventId, (Object)list);
        return true;
    }

    protected boolean tryExecute(LivingEntity living, @Nullable LivingEntity other) {
        LivingEntity target;
        if (!MPRCondition.conditionsApply(this.conditions, living)) {
            return false;
        }
        LivingEntity livingEntity = target = this.target == Target.THIS ? living : other;
        if (target == null) {
            return false;
        }
        this.executeFor(target);
        return true;
    }

    protected void executeFor(LivingEntity living) {
        this.tryApplyProperty(living);
    }

    public void tryApplyProperty(LivingEntity entity) {
        for (MPRProperty applyProperty : this.applyProperties) {
            applyProperty.tryApply(entity);
        }
        MPRScalePehkuiProperty.applyScheduled(entity);
    }

    public static <T extends MPREvent> List<T> getEvents(LivingEntity living, Class<T> typeId) {
        ArrayList<MPREvent> events = new ArrayList<MPREvent>();
        ResourceLocation eventId = MPREvent.getId(typeId);
        if (eventId == null) {
            return events;
        }
        ListTag list = ModNBTData.getList((Entity)living, (ResourceLocation)eventId, (int)8);
        for (int i = 0; i < list.size(); ++i) {
            MPREvent event;
            ResourceLocation id = ResourceLocation.parse((String)list.m_128778_(i));
            if (!LOADED_EVENTS.containsKey(id) || !typeId.isInstance(event = LOADED_EVENTS.get(id))) continue;
            events.add((MPREvent)typeId.cast(event));
        }
        return events;
    }

    public static ResourceLocation getId(Class<? extends MPREvent> clazz) {
        ResourceLocation eventId = EventsRegistry.getId(clazz);
        if (eventId == null) {
            return null;
        }
        return ResourceLocation.parse((String)(eventId.m_135827_() + ":events/" + eventId.m_135815_()));
    }

    @Nullable
    public static MPRProperty deserializeProperty(JsonObject jObject, JsonDeserializationContext context) {
        if (!jObject.has("apply_property")) {
            return null;
        }
        return MPRProperty.deserialize(jObject.get("apply_property"), context);
    }

    public JsonObject endSerialization(JsonObject jObject, JsonSerializationContext context, boolean includeTarget) {
        jObject.addProperty("id", this.id.toString());
        if (includeTarget) {
            jObject.add("target", context.serialize((Object)this.target));
        }
        if (!this.applyProperties.isEmpty()) {
            jObject.add("apply_properties", context.serialize(this.applyProperties));
        }
        return super.endSerialization(jObject, context);
    }

    @Nullable
    public static MPREvent deserialize(JsonElement json, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jObjectProperty = json.getAsJsonObject();
        ResourceLocation eventId = MPR.locationFrom(GsonHelper.m_13906_((JsonObject)jObjectProperty, (String)"event"));
        Class<? extends MPREvent> eventType = EventsRegistry.get(eventId);
        if (eventType == null) {
            Logger.warn("event %s does not exist. Skipping".formatted(eventId), new Object[0]);
            return null;
        }
        return (MPREvent)context.deserialize((JsonElement)jObjectProperty, eventType);
    }

    public static List<MPREvent> deserializeList(JsonObject jObject, String memberName, JsonDeserializationContext context) {
        ArrayList<MPREvent> events = new ArrayList<MPREvent>();
        if (!jObject.has(memberName)) {
            return events;
        }
        JsonArray aEvents = GsonHelper.m_13933_((JsonObject)jObject, (String)memberName);
        for (JsonElement jsonElement : aEvents) {
            MPREvent event = MPREvent.deserialize(jsonElement, context);
            if (event == null) continue;
            events.add(event);
        }
        return events;
    }
}

