/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.util.modifiable;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import insane96mcp.insanelib.util.MathHelper;
import insane96mcp.mobspropertiesrandomness.data.json.util.modifiable.MPRModifier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;

public abstract class MPRModifiable {
    public List<MPRModifier> modifiers;
    public Integer round;

    public MPRModifiable(List<MPRModifier> modifiers, Integer round) {
        this.modifiers = modifiers;
        this.round = round;
    }

    public double applyModifiers(double value, LivingEntity living) {
        for (MPRModifier modifier : this.modifiers) {
            value = modifier.tryApply(value, living);
        }
        return value;
    }

    public double applyModifiersAndRound(double value, LivingEntity living) {
        return this.round(this.applyModifiers(value, living));
    }

    public double round(double value) {
        if (this.round == null) {
            return value;
        }
        return MathHelper.round((double)value, (int)this.round);
    }

    public static List<MPRModifier> deserializeList(JsonObject jObject, JsonDeserializationContext context) {
        if (!jObject.has("modifiers")) {
            return new ArrayList<MPRModifier>();
        }
        return MPRModifier.deserializeList(jObject, "modifiers", context);
    }

    public JsonObject endSerialization(JsonObject jObject, JsonSerializationContext context) {
        if (!this.modifiers.isEmpty()) {
            jObject.add("modifiers", context.serialize(this.modifiers));
        }
        if (this.round != null) {
            jObject.addProperty("round", (Number)this.round);
        }
        return jObject;
    }
}

