/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.mobspropertiesrandomness.data.json.util.modifiable.MPRRange;
import insane96mcp.mobspropertiesrandomness.util.Logger;
import insane96mcp.mobspropertiesrandomness.util.SerializerUtils;
import java.lang.reflect.Type;
import java.util.UUID;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;

@JsonAdapter(value=Serializer.class)
public class MPRAttributeModifier {
    public UUID uuid;
    public Attribute attribute;
    public String modifierName;
    public MPRRange amount;
    public AttributeModifier.Operation operation;

    public MPRAttributeModifier(Attribute attribute, UUID uuid, String modifierName, MPRRange amount, AttributeModifier.Operation operation) {
        this.uuid = uuid;
        this.attribute = attribute;
        this.modifierName = modifierName;
        this.amount = amount;
        this.operation = operation;
    }

    public AttributeModifier getModifier(LivingEntity living) {
        return new AttributeModifier(UUID.randomUUID(), this.modifierName, this.amount.getDoubleBetween(living), this.operation);
    }

    public static void fixHealth(LivingEntity entity) {
        AttributeInstance attributeInstance = entity.m_21051_(Attributes.f_22276_);
        if (attributeInstance != null) {
            entity.m_21153_((float)attributeInstance.m_22135_());
        }
        entity.m_21153_((float)entity.m_21133_(Attributes.f_22276_));
    }

    public static class Serializer
    implements JsonDeserializer<MPRAttributeModifier>,
    JsonSerializer<MPRAttributeModifier> {
        public MPRAttributeModifier deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            Attribute attribute = (Attribute)SerializerUtils.deserializeRegistryObject(jObject, "attribute", Registries.f_256728_);
            if (attribute == null) {
                Logger.warn("Invalid attribute: %s. Will be ignored.", jObject.get("attribute").getAsString());
            }
            UUID uuid = jObject.has("uuid") ? UUID.fromString(GsonHelper.m_13906_((JsonObject)jObject, (String)"uuid")) : UUID.randomUUID();
            String modifierName = GsonHelper.m_13906_((JsonObject)jObject, (String)"modifier_name");
            MPRRange amount = (MPRRange)GsonHelper.m_13836_((JsonObject)jObject, (String)"amount", (JsonDeserializationContext)context, MPRRange.class);
            AttributeModifier.Operation operation = (AttributeModifier.Operation)GsonHelper.m_13836_((JsonObject)jObject, (String)"operation", (JsonDeserializationContext)context, AttributeModifier.Operation.class);
            return new MPRAttributeModifier(attribute, uuid, modifierName, amount, operation);
        }

        public JsonElement serialize(MPRAttributeModifier src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            jObject.add("attribute", SerializerUtils.serializeRegistryObject(src.attribute, Registries.f_256728_));
            jObject.addProperty("uuid", src.uuid.toString());
            jObject.addProperty("modifier_name", src.modifierName);
            jObject.add("amount", context.serialize((Object)src.amount));
            jObject.add("operation", context.serialize((Object)src.operation));
            return jObject;
        }
    }
}

