/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.property;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import insane96mcp.mobspropertiesrandomness.data.json.property.MPRProperty;
import insane96mcp.mobspropertiesrandomness.data.json.util.modifiable.MPRRange;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;

@JsonAdapter(value=Serializer.class)
public class MPRFireProperty
extends MPRProperty {
    public MPRRange secondsOnFire;
    public boolean additive;

    public MPRFireProperty(MPRRange secondsOnFire, boolean additive, List<MPRCondition> conditions) {
        super(conditions);
        this.secondsOnFire = secondsOnFire;
        this.additive = additive;
    }

    @Override
    public boolean apply(LivingEntity living) {
        int fireTicks = (int)(this.secondsOnFire.getDoubleBetween(living) * 20.0);
        if (this.additive) {
            fireTicks += living.m_20094_();
        }
        living.m_7311_(fireTicks);
        return true;
    }

    public static class Serializer
    implements JsonDeserializer<MPRFireProperty>,
    JsonSerializer<MPRFireProperty> {
        public MPRFireProperty deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            return new MPRFireProperty((MPRRange)GsonHelper.m_13836_((JsonObject)jObject, (String)"seconds_on_fire", (JsonDeserializationContext)context, MPRRange.class), GsonHelper.m_13855_((JsonObject)jObject, (String)"additive", (boolean)false), MPRCondition.deserializeConditions(jObject, context));
        }

        public JsonElement serialize(MPRFireProperty src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            jObject.add("seconds_on_fire", context.serialize((Object)src.secondsOnFire));
            if (src.additive) {
                jObject.addProperty("additive", Boolean.valueOf(true));
            }
            return src.endSerialization(jObject, context);
        }
    }
}

