/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.module.base.feature;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.base.Module;
import insane96mcp.insanelib.base.config.Config;
import insane96mcp.insanelib.util.ModNBTData;
import insane96mcp.mobspropertiesrandomness.MPR;
import insane96mcp.mobspropertiesrandomness.data.MPRMobReloadListener;
import insane96mcp.mobspropertiesrandomness.data.MPRPresetReloadListener;
import insane96mcp.mobspropertiesrandomness.data.json.MPRAttributeModifier;
import insane96mcp.mobspropertiesrandomness.data.json.MPRMob;
import insane96mcp.mobspropertiesrandomness.data.json.MPRProperties;
import insane96mcp.mobspropertiesrandomness.data.json.property.MPRBossBarProperty;
import insane96mcp.mobspropertiesrandomness.data.json.property.MPREffectImmunityProperty;
import insane96mcp.mobspropertiesrandomness.data.json.property.MPRScalePehkuiProperty;
import insane96mcp.mobspropertiesrandomness.data.json.property.events.MPRChangeTargetEvent;
import insane96mcp.mobspropertiesrandomness.data.json.property.events.MPRDeathEvent;
import insane96mcp.mobspropertiesrandomness.data.json.property.events.MPRKillEvent;
import insane96mcp.mobspropertiesrandomness.data.json.property.events.MPROnHitEvent;
import insane96mcp.mobspropertiesrandomness.data.json.property.events.MPRTickEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityLeaveLevelEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@LoadFeature(module="mobspropertiesrandomness:base", canBeDisabled=false)
public class MPRBase
extends Feature {
    public static final ResourceLocation PROCESSED = MPR.location("processed");
    public static final ResourceLocation PRESET = MPR.location("preset");
    @Config(description="If true creeper lingering clouds size changes based off their explosion radius.")
    public static Boolean betterCreeperLingering = true;
    @Config
    public static Boolean verboseLog = false;

    public MPRBase(Module module, boolean enabledByDefault, boolean canBeDisabled) {
        super(module, enabledByDefault, canBeDisabled);
    }

    public static void postActualHurt(LivingEntity living, DamageSource source, float amount) {
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onEntityJoinWorld(EntityJoinLevelEvent event) {
        if (event.getLevel().f_46443_) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        MPRBase.tryApplyPreset(livingEntity);
        if (((Boolean)ModNBTData.get((Entity)livingEntity, (ResourceLocation)PROCESSED, Boolean.class)).booleanValue()) {
            return;
        }
        if (MPRMobReloadListener.MPR_MOBS.isEmpty()) {
            return;
        }
        for (MPRMob mprMob : MPRMobReloadListener.MPR_MOBS) {
            mprMob.tryApply(livingEntity);
        }
        ModNBTData.put((Entity)livingEntity, (ResourceLocation)PROCESSED, (Object)true);
        MPRAttributeModifier.fixHealth(livingEntity);
    }

    public static void tryApplyPreset(LivingEntity living) {
        if (!ModNBTData.contains((Entity)living, (ResourceLocation)PRESET)) {
            return;
        }
        ResourceLocation rl = ResourceLocation.m_135820_((String)((String)ModNBTData.get((Entity)living, (ResourceLocation)PRESET, String.class)));
        if (rl == null) {
            return;
        }
        MPRProperties preset = MPRPresetReloadListener.PRESETS.get(rl);
        if (preset == null) {
            return;
        }
        preset.forceApply(living);
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent event) {
        MPROnHitEvent.onHit(event);
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        MPRDeathEvent.onDeath(event);
        MPRKillEvent.onKill(event);
    }

    @SubscribeEvent
    public void onTargetSwitch(LivingChangeTargetEvent event) {
        MPRChangeTargetEvent.onTargetChange(event);
    }

    @SubscribeEvent
    public void onEntityLeaveLevel(EntityLeaveLevelEvent event) {
        MPRBossBarProperty.removeBar(event.getEntity());
    }

    @SubscribeEvent
    public void onApplyEffect(MobEffectEvent.Applicable event) {
        if (MPREffectImmunityProperty.shouldPreventEffect(event.getEntity(), event.getEffectInstance().m_19544_())) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingTickEvent event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        this.tryApplyPehkui(event.getEntity());
        MPRBossBarProperty.showBar((Entity)event.getEntity(), true);
        MPRBossBarProperty.updateBar((Entity)event.getEntity());
        MPRTickEvent.tickEvents(event.getEntity());
    }

    public void tryApplyPehkui(LivingEntity entity) {
        if (entity.f_19797_ == 1) {
            MPRScalePehkuiProperty.applyScheduled(entity);
        }
    }

    @SubscribeEvent
    public void onStopTracking(PlayerEvent.StopTracking event) {
        MPRBossBarProperty.removePlayer(event.getTarget(), event.getEntity());
    }

    public static boolean isBetterCreeperLingeringEnabled() {
        return Feature.isEnabled(MPRBase.class) && betterCreeperLingering != false;
    }
}

