/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.mobspropertiesrandomness.data.json.WeightedResourceLocation;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import insane96mcp.mobspropertiesrandomness.data.json.util.modifiable.MPRModifiableValue;
import java.lang.reflect.Type;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;

@JsonAdapter(value=Serializer.class)
public class WeightedLootTable
extends WeightedResourceLocation {
    public WeightedLootTable(MPRModifiableValue modifiableWeight, ResourceLocation location, List<MPRCondition> conditions) {
        super(modifiableWeight, location, conditions);
    }

    @Override
    @Nullable
    public WeightedLootTable computeAndGet(LivingEntity entity) {
        if (!MPRCondition.conditionsApply(this.conditions, entity)) {
            return null;
        }
        this._weight = (int)this.modifiableWeight.getValue(entity);
        if (this._weight <= 0) {
            return null;
        }
        return this;
    }

    public static class Serializer
    implements JsonSerializer<WeightedLootTable>,
    JsonDeserializer<WeightedLootTable> {
        public WeightedLootTable deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            return new WeightedLootTable((MPRModifiableValue)GsonHelper.m_13845_((JsonObject)jObject, (String)"weight", (Object)new MPRModifiableValue(1.0), (JsonDeserializationContext)context, MPRModifiableValue.class), ResourceLocation.parse((String)GsonHelper.m_13906_((JsonObject)jObject, (String)"loot_table")), MPRCondition.deserializeConditions(jObject, context));
        }

        public JsonElement serialize(WeightedLootTable src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            jObject.add("weight", context.serialize((Object)src.modifiableWeight));
            jObject.add("loot_table", context.serialize((Object)src.location));
            return src.endSerialization(jObject, context);
        }
    }
}

