/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.condition;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

@JsonAdapter(value=Serializer.class)
public class MPRDimensionCondition
extends MPRCondition {
    List<ResourceKey<Level>> dimensions;

    public MPRDimensionCondition(List<ResourceKey<Level>> dimensions, boolean inverted) {
        super(inverted);
        this.dimensions = dimensions;
    }

    @Override
    protected boolean conditionCheck(LivingEntity living) {
        for (ResourceKey<Level> dimension : this.dimensions) {
            if (!living.m_9236_().m_46472_().equals(dimension)) continue;
            return true;
        }
        return false;
    }

    public static class Serializer
    implements JsonDeserializer<MPRDimensionCondition>,
    JsonSerializer<MPRDimensionCondition> {
        public MPRDimensionCondition deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            JsonArray aDimensions = jObject.getAsJsonArray("dimensions");
            if (aDimensions == null) {
                throw new JsonParseException("Missing dimensions array");
            }
            ArrayList<ResourceKey<Level>> dimensions = new ArrayList<ResourceKey<Level>>();
            for (JsonElement jsonElement : aDimensions) {
                ResourceKey rk = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)ResourceLocation.parse((String)jsonElement.getAsString()));
                dimensions.add((ResourceKey<Level>)rk);
            }
            return new MPRDimensionCondition(dimensions, MPRCondition.deserializeInverted(jObject));
        }

        public JsonElement serialize(MPRDimensionCondition src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            JsonArray aDimensions = new JsonArray();
            for (ResourceKey<Level> dimension : src.dimensions) {
                aDimensions.add(dimension.m_135782_().toString());
            }
            jObject.add("dimensions", (JsonElement)aDimensions);
            return src.endSerialization(jObject);
        }
    }
}

