/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.condition;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.insanelib.util.LogHelper;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.levelgen.structure.Structure;

@JsonAdapter(value=Serializer.class)
public class MPRStructureCondition
extends MPRCondition {
    List<ResourceKey<Structure>> structures;

    public MPRStructureCondition(List<ResourceKey<Structure>> structures, boolean inverted) {
        super(inverted);
        this.structures = structures;
    }

    @Override
    protected boolean conditionCheck(LivingEntity living) {
        for (ResourceKey<Structure> structure : this.structures) {
            StructureManager structureManager = ((ServerLevel)living.m_9236_()).m_215010_();
            Structure s = (Structure)structureManager.m_220521_().m_175515_(Registries.f_256944_).m_6246_(structure);
            if (s == null) {
                LogHelper.warn((String)"No structure found with id %s. Ignored", (Object[])new Object[]{structure.m_135782_()});
                if (living.m_20194_() == null) continue;
                living.m_20194_().m_213846_((Component)Component.m_237113_((String)("No structure found with id " + String.valueOf(structure.m_135782_()))));
                continue;
            }
            if (!structureManager.m_220494_(living.m_20183_(), s).m_73603_()) continue;
            return true;
        }
        return false;
    }

    public static class Serializer
    implements JsonDeserializer<MPRStructureCondition>,
    JsonSerializer<MPRStructureCondition> {
        public MPRStructureCondition deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            JsonArray aStructures = jObject.getAsJsonArray("structures");
            if (aStructures == null) {
                throw new JsonParseException("Missing structures array");
            }
            ArrayList<ResourceKey<Structure>> structures = new ArrayList<ResourceKey<Structure>>();
            for (JsonElement jsonElement : aStructures) {
                ResourceKey rk = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)ResourceLocation.parse((String)jsonElement.getAsString()));
                structures.add((ResourceKey<Structure>)rk);
            }
            return new MPRStructureCondition(structures, MPRCondition.deserializeInverted(jObject));
        }

        public JsonElement serialize(MPRStructureCondition src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            JsonArray aStructures = new JsonArray();
            for (ResourceKey<Structure> structure : src.structures) {
                aStructures.add(structure.m_135782_().toString());
            }
            jObject.add("structures", (JsonElement)aStructures);
            return src.endSerialization(jObject);
        }
    }
}

