/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.property.events;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import insane96mcp.mobspropertiesrandomness.data.json.property.MPRProperty;
import insane96mcp.mobspropertiesrandomness.data.json.property.events.MPREvent;
import insane96mcp.mobspropertiesrandomness.data.json.property.events.MPRHurtData;
import insane96mcp.mobspropertiesrandomness.data.json.property.events.Target;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.commands.CommandFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import org.jetbrains.annotations.Nullable;

@JsonAdapter(value=Serializer.class)
public class MPRKillEvent
extends MPREvent {
    public MPRHurtData hurtData;

    public MPRKillEvent(MPRHurtData hurtData, ResourceLocation id, Target target, @Nullable CommandFunction.CacheableFunction function, @Nullable List<MPRProperty> applyProperties, List<MPRCondition> conditions) {
        super(id, target, function, applyProperties, conditions);
        this.hurtData = hurtData;
    }

    public void kill(LivingEntity entity, @Nullable LivingEntity killedEntity, DamageSource source, boolean isDirectDamage) {
        if (!this.hurtData.shouldApply(source, isDirectDamage)) {
            return;
        }
        this.tryExecute(entity, killedEntity);
    }

    public static void onKill(LivingDeathEvent event) {
        LivingEntity living = event.getEntity();
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity killer = (LivingEntity)entity;
        List<MPRKillEvent> events = MPRKillEvent.getEvents(killer, MPRKillEvent.class);
        for (MPRKillEvent killEvent : events) {
            killEvent.kill(killer, living, event.getSource(), event.getSource().m_7640_() == event.getSource().m_7639_());
        }
    }

    public static class Serializer
    implements JsonDeserializer<MPRKillEvent>,
    JsonSerializer<MPRKillEvent> {
        public MPRKillEvent deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            String id = GsonHelper.m_13906_((JsonObject)jObject, (String)"id");
            Target target = (Target)((Object)GsonHelper.m_13836_((JsonObject)jObject, (String)"target", (JsonDeserializationContext)context, Target.class));
            CommandFunction.CacheableFunction function = MPREvent.deserializeFunction(jObject);
            List<MPRCondition> conditions = MPRCondition.deserializeConditions(jObject, context);
            List<MPRProperty> properties = MPRProperty.deserializeList(jObject, "apply_properties", context);
            return new MPRKillEvent(MPRHurtData.deserialize(jObject, context), ResourceLocation.parse((String)id), target, function, properties, conditions);
        }

        public JsonElement serialize(MPRKillEvent src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            jObject.add("hurt_data", context.serialize((Object)src.hurtData));
            return src.endSerialization(jObject, context, false);
        }
    }
}

