/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.util.modifiable;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.mobspropertiesrandomness.data.json.util.modifiable.MPRModifiable;
import insane96mcp.mobspropertiesrandomness.data.json.util.modifiable.MPRModifiableValue;
import insane96mcp.mobspropertiesrandomness.data.json.util.modifiable.MPRModifier;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;

@JsonAdapter(value=Serializer.class)
public class MPRRange
extends MPRModifiableValue {
    private final Double max;
    private final Bias bias;
    private ModifiersBehaviour modifiersBehaviour;
    public static final MPRRange ZERO = new MPRRange(0.0);
    public static final MPRRange ONE = new MPRRange(1.0);

    public MPRRange(Double value) {
        this(value, null, null, Bias.NONE, List.of(), null);
    }

    public MPRRange(Double min, Double max) {
        this(min, max, null, Bias.NONE, List.of(), null);
    }

    public MPRRange(Double min, @Nullable Double max, @Nullable ModifiersBehaviour modifiersBehaviour, Bias bias, List<MPRModifier> conditionsModifier, @Nullable Integer round) {
        super(min, conditionsModifier, round);
        this.max = max != null ? max : min;
        this.modifiersBehaviour = modifiersBehaviour;
        if (this.modifiersBehaviour == null) {
            this.modifiersBehaviour = ModifiersBehaviour.BOTH;
        }
        this.bias = bias;
    }

    public double getMin(LivingEntity living) {
        if (this.modifiersBehaviour != ModifiersBehaviour.MAX_ONLY) {
            return this.applyModifiersAndRound(this.value, living);
        }
        return this.value;
    }

    public double getMax(LivingEntity living) {
        if (this.modifiersBehaviour != ModifiersBehaviour.MIN_ONLY) {
            return this.applyModifiersAndRound(this.max, living);
        }
        return this.max;
    }

    @Override
    public double getValue(LivingEntity living) {
        return this.getDoubleBetween(living);
    }

    public double getDoubleBetween(LivingEntity entity) {
        RandomSource random = entity.m_9236_().f_46441_;
        double min = this.applyModifiers(this.value, entity);
        double max = this.applyModifiers(this.max, entity);
        if (this.bias == Bias.NONE) {
            return Mth.m_216263_((RandomSource)random, (double)min, (double)max);
        }
        if (this.bias != Bias.MIDDLE) {
            double t = random.m_188500_();
            double biased = random.m_188500_() * t;
            return this.bias == Bias.MIN ? min + biased * (max - min) : max - biased * (max - min);
        }
        return random.m_216328_((min + max) / 2.0, (max - min) / 2.0);
    }

    public int getIntBetween(LivingEntity entity) {
        return (int)this.getDoubleBetween(entity);
    }

    public boolean isBetween(LivingEntity entity, double value) {
        return value >= this.getMin(entity) && value <= this.getMax(entity);
    }

    public static enum Bias {
        NONE,
        MIN,
        MAX,
        MIDDLE;

    }

    public static enum ModifiersBehaviour {
        BOTH,
        MIN_ONLY,
        MAX_ONLY;

    }

    public static class Serializer
    implements JsonSerializer<MPRRange>,
    JsonDeserializer<MPRRange> {
        public MPRRange deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            double min;
            if (json.isJsonPrimitive()) {
                return new MPRRange(json.getAsDouble());
            }
            JsonObject jObject = json.getAsJsonObject();
            if (!jObject.has("min")) {
                if (!jObject.has("value")) {
                    throw new JsonParseException("Missing min or value");
                }
                min = GsonHelper.m_144784_((JsonObject)jObject, (String)"value");
            } else {
                min = GsonHelper.m_144784_((JsonObject)jObject, (String)"min");
            }
            double max = GsonHelper.m_144742_((JsonObject)jObject, (String)"max", (double)min);
            if (min > max) {
                throw new JsonParseException("Min cannot be greater than max");
            }
            Bias bias = jObject.has("bias") ? (Bias)((Object)GsonHelper.m_13836_((JsonObject)jObject, (String)"bias", (JsonDeserializationContext)context, Bias.class)) : Bias.NONE;
            return new MPRRange(min, max, (ModifiersBehaviour)((Object)GsonHelper.m_13845_((JsonObject)jObject, (String)"modifiers_behaviour", null, (JsonDeserializationContext)context, ModifiersBehaviour.class)), bias, MPRModifiable.deserializeList(jObject, context), (Integer)GsonHelper.m_13845_((JsonObject)jObject, (String)"round", null, (JsonDeserializationContext)context, Integer.class));
        }

        public JsonElement serialize(MPRRange src, Type typeOfSrc, JsonSerializationContext context) {
            if (Objects.equals(src.value, src.max) && src.modifiersBehaviour == ModifiersBehaviour.BOTH && src.modifiers.isEmpty() && src.round == null) {
                return new JsonPrimitive((Number)src.value);
            }
            JsonObject jObject = new JsonObject();
            jObject.addProperty("min", (Number)src.value);
            jObject.addProperty("max", (Number)src.max);
            if (src.modifiersBehaviour != ModifiersBehaviour.BOTH) {
                jObject.add("modifiers_behaviour", context.serialize((Object)src.modifiersBehaviour));
            }
            return src.endSerialization(jObject, context);
        }
    }
}

