/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.property;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import insane96mcp.mobspropertiesrandomness.data.json.property.MPRProperty;
import insane96mcp.mobspropertiesrandomness.data.json.util.modifiable.MPRRange;
import insane96mcp.mobspropertiesrandomness.util.Logger;
import insane96mcp.mobspropertiesrandomness.util.SerializerUtils;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;

@JsonAdapter(value=Serializer.class)
public class MPRPotionEffectProperty
extends MPRProperty {
    public MobEffect mobEffect;
    public MPRRange amplifier;
    public MPRRange duration;
    public boolean stackDuration;
    public boolean ambient;
    public boolean hideParticles;

    public MPRPotionEffectProperty(MobEffect mobEffect, MPRRange amplifier, MPRRange duration, boolean stackDuration, boolean ambient, boolean hideParticles, List<MPRCondition> conditions) {
        super(conditions);
        this.mobEffect = mobEffect;
        this.amplifier = amplifier;
        this.duration = duration;
        this.stackDuration = stackDuration;
        this.ambient = ambient;
        this.hideParticles = hideParticles;
    }

    @Override
    public boolean apply(LivingEntity living) {
        if (this.mobEffect == null) {
            return false;
        }
        double duration = this.duration.getDoubleBetween(living);
        if (living.m_21124_(this.mobEffect) != null && this.stackDuration && duration != -1.0) {
            duration += (double)living.m_21124_(this.mobEffect).m_19557_() / 20.0;
        }
        MobEffectInstance effectInstance = new MobEffectInstance(this.mobEffect, (int)(duration == -1.0 ? -1.0 : duration * 20.0), this.amplifier.getIntBetween(living), this.ambient, !this.hideParticles, false);
        living.m_7292_(effectInstance);
        return true;
    }

    public static class Serializer
    implements JsonDeserializer<MPRPotionEffectProperty>,
    JsonSerializer<MPRPotionEffectProperty> {
        public MPRPotionEffectProperty deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            MobEffect mobEffect = (MobEffect)SerializerUtils.deserializeRegistryObject(jObject, "effect", Registries.f_256929_);
            if (mobEffect == null) {
                Logger.warn("Invalid effect: %s. Will be ignored.", jObject.get("effect").getAsString());
            }
            MPRRange amplifier = jObject.has("amplifier") ? (MPRRange)context.deserialize(jObject.get("amplifier"), MPRRange.class) : MPRRange.ZERO;
            MPRRange duration = (MPRRange)GsonHelper.m_13845_((JsonObject)jObject, (String)"duration", (Object)new MPRRange(-1.0), (JsonDeserializationContext)context, MPRRange.class);
            boolean ambient = GsonHelper.m_13855_((JsonObject)jObject, (String)"ambient", (boolean)false);
            boolean hideParticles = GsonHelper.m_13855_((JsonObject)jObject, (String)"hide_particles", (boolean)false);
            if (ambient && hideParticles) {
                Logger.warn("Particles are hidden, but ambient is enabled for %s. Ambient doesn't work if particles are hidden.".formatted(mobEffect), new Object[0]);
            }
            return new MPRPotionEffectProperty(mobEffect, amplifier, duration, GsonHelper.m_13855_((JsonObject)jObject, (String)"stack_duration", (boolean)false), ambient, hideParticles, MPRCondition.deserializeConditions(jObject, context));
        }

        public JsonElement serialize(MPRPotionEffectProperty src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            jObject.add("effect", SerializerUtils.serializeRegistryObject(src.mobEffect, Registries.f_256929_));
            jObject.add("amplifier", context.serialize((Object)src.amplifier));
            jObject.add("duration", context.serialize((Object)src.duration));
            if (src.stackDuration) {
                jObject.addProperty("stack_duration", Boolean.valueOf(true));
            }
            jObject.addProperty("ambient", Boolean.valueOf(src.ambient));
            jObject.addProperty("hide_particles", Boolean.valueOf(src.hideParticles));
            return src.endSerialization(jObject, context);
        }
    }
}

