/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.property;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.insanelib.util.weightedrandom.WeightedRandom;
import insane96mcp.mobspropertiesrandomness.data.json.WeightedLootTable;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import insane96mcp.mobspropertiesrandomness.data.json.property.MPRProperty;
import insane96mcp.mobspropertiesrandomness.util.SerializerUtils;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

@JsonAdapter(value=Serializer.class)
public class MPRLootTableProperty
extends MPRProperty {
    public List<WeightedLootTable> lootTables;

    public MPRLootTableProperty(List<WeightedLootTable> lootTables, List<MPRCondition> conditions) {
        super(conditions);
        this.lootTables = lootTables;
    }

    @Override
    public boolean apply(LivingEntity living) {
        if (!(living instanceof Mob)) {
            return false;
        }
        Mob mob = (Mob)living;
        ArrayList<WeightedLootTable> weightedList = new ArrayList<WeightedLootTable>();
        for (WeightedLootTable lootTable : this.lootTables) {
            WeightedLootTable computedWeighted = lootTable.computeAndGet(living);
            if (computedWeighted == null) continue;
            weightedList.add(computedWeighted);
        }
        if (weightedList.isEmpty()) {
            return false;
        }
        mob.f_21355_ = ((WeightedLootTable)WeightedRandom.getRandomItem((RandomSource)living.m_217043_(), weightedList)).getLocation();
        return true;
    }

    public static class Serializer
    implements JsonDeserializer<MPRLootTableProperty>,
    JsonSerializer<MPRLootTableProperty> {
        public MPRLootTableProperty deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            List<WeightedLootTable> weightedLootTables = SerializerUtils.deserializeList(jObject, "loot_tables", context, WeightedLootTable.class, true);
            if (weightedLootTables.isEmpty()) {
                throw new JsonParseException("No loot_tables specified for Loot Table Property");
            }
            return new MPRLootTableProperty(weightedLootTables, MPRCondition.deserializeConditions(jObject, context));
        }

        public JsonElement serialize(MPRLootTableProperty src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            jObject.add("loot_tables", context.serialize(src.lootTables));
            return src.endSerialization(jObject, context);
        }
    }
}

