/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.property.events;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import insane96mcp.mobspropertiesrandomness.data.json.property.MPRProperty;
import insane96mcp.mobspropertiesrandomness.data.json.property.events.MPREvent;
import insane96mcp.mobspropertiesrandomness.data.json.property.events.Target;
import java.lang.reflect.Type;
import java.util.List;
import net.minecraft.commands.CommandFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import org.jetbrains.annotations.Nullable;

@JsonAdapter(value=Serializer.class)
public class MPRChangeTargetEvent
extends MPREvent {
    public final ChangeType changeType;

    public MPRChangeTargetEvent(ChangeType changeType, ResourceLocation id, Target target, @Nullable CommandFunction.CacheableFunction function, @Nullable List<MPRProperty> applyProperties, List<MPRCondition> conditions) {
        super(id, target, function, applyProperties, conditions);
        this.changeType = changeType;
    }

    public void switchTarget(LivingEntity entity, @Nullable LivingEntity newTarget, @Nullable LivingEntity oldTarget) {
        switch (this.changeType) {
            case NEW_TARGET: {
                if (oldTarget != null || newTarget == null) break;
                this.tryExecute(entity, newTarget);
                break;
            }
            case SWITCH_TARGET: {
                if (oldTarget == null || newTarget == null || oldTarget == newTarget) break;
                this.tryExecute(entity, newTarget);
                break;
            }
            case LOST_TARGET: {
                if (oldTarget == null || newTarget != null) break;
                this.tryExecute(entity, null);
            }
        }
    }

    public static void onTargetChange(LivingChangeTargetEvent event) {
        Mob mob = (Mob)event.getEntity();
        List<MPRChangeTargetEvent> events = MPRChangeTargetEvent.getEvents((LivingEntity)mob, MPRChangeTargetEvent.class);
        for (MPRChangeTargetEvent switchTargetEvent : events) {
            switchTargetEvent.switchTarget((LivingEntity)mob, event.getNewTarget(), mob.m_5448_());
        }
    }

    public static enum ChangeType {
        NEW_TARGET,
        SWITCH_TARGET,
        LOST_TARGET;

    }

    public static class Serializer
    implements JsonDeserializer<MPRChangeTargetEvent>,
    JsonSerializer<MPRChangeTargetEvent> {
        public MPRChangeTargetEvent deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            String id = GsonHelper.m_13906_((JsonObject)jObject, (String)"id");
            Target target = (Target)((Object)GsonHelper.m_13836_((JsonObject)jObject, (String)"target", (JsonDeserializationContext)context, Target.class));
            CommandFunction.CacheableFunction function = MPREvent.deserializeFunction(jObject);
            List<MPRCondition> conditions = MPRCondition.deserializeConditions(jObject, context);
            List<MPRProperty> properties = MPRProperty.deserializeList(jObject, "apply_properties", context);
            return new MPRChangeTargetEvent((ChangeType)((Object)GsonHelper.m_13836_((JsonObject)jObject, (String)"type", (JsonDeserializationContext)context, ChangeType.class)), ResourceLocation.parse((String)id), target, function, properties, conditions);
        }

        public JsonElement serialize(MPRChangeTargetEvent src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            jObject.add("type", context.serialize((Object)src.changeType));
            return src.endSerialization(jObject, context, false);
        }
    }
}

