/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.data.json.util.modifiable;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.annotations.JsonAdapter;
import insane96mcp.mobspropertiesrandomness.data.json.condition.MPRCondition;
import insane96mcp.mobspropertiesrandomness.data.json.util.modifiable.MPRModifiableValue;
import insane96mcp.mobspropertiesrandomness.data.json.util.modifiable.MPRModifier;
import insane96mcp.mobspropertiesrandomness.data.json.util.modifiable.MPRRange;
import java.lang.reflect.Type;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

@JsonAdapter(value=Serializer.class)
public class MPRDistanceFromSpawnModifier
extends MPRModifier {
    public MPRRange amountPerBlocks;
    public MPRModifiableValue blocks;
    public MPRModifiableValue shift;
    @Nullable
    public MPRModifiableValue cap;

    public MPRDistanceFromSpawnModifier(MPRRange amountPerBlocks, MPRModifiableValue blocks, MPRModifiableValue shift, @Nullable MPRModifiableValue cap, MPRModifier.Operation operation, List<MPRCondition> conditions) {
        super(operation, conditions);
        this.amountPerBlocks = amountPerBlocks;
        this.blocks = blocks;
        this.shift = shift;
        this.cap = cap;
    }

    @Override
    protected double getModifier(LivingEntity living) {
        Vec3 spawnPos = new Vec3((double)living.m_9236_().m_6106_().m_6789_(), (double)living.m_9236_().m_6106_().m_6527_(), (double)living.m_9236_().m_6106_().m_6526_());
        double distance = (float)spawnPos.m_82554_(living.m_20182_());
        double modifier = (distance += this.shift.getValue(living)) / this.blocks.getValue(living) * this.amountPerBlocks.getValue(living);
        if (this.cap != null) {
            modifier = Math.min(modifier, this.cap.getValue(living));
        }
        return modifier;
    }

    public static class Serializer
    implements JsonDeserializer<MPRDistanceFromSpawnModifier>,
    JsonSerializer<MPRDistanceFromSpawnModifier> {
        public MPRDistanceFromSpawnModifier deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jObject = json.getAsJsonObject();
            return new MPRDistanceFromSpawnModifier((MPRRange)GsonHelper.m_13836_((JsonObject)jObject, (String)"amount_per_blocks", (JsonDeserializationContext)context, MPRRange.class), (MPRModifiableValue)GsonHelper.m_13836_((JsonObject)jObject, (String)"blocks", (JsonDeserializationContext)context, MPRModifiableValue.class), (MPRModifiableValue)GsonHelper.m_13845_((JsonObject)jObject, (String)"shift", (Object)MPRModifiableValue.ZERO, (JsonDeserializationContext)context, MPRModifiableValue.class), (MPRModifiableValue)GsonHelper.m_13845_((JsonObject)jObject, (String)"cap", null, (JsonDeserializationContext)context, MPRModifiableValue.class), MPRModifier.deserializeOperation(jObject, context), MPRCondition.deserializeConditions(jObject, context));
        }

        public JsonElement serialize(MPRDistanceFromSpawnModifier src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jObject = new JsonObject();
            jObject.add("amount_per_blocks", context.serialize((Object)src.amountPerBlocks));
            jObject.add("blocks", context.serialize((Object)src.blocks));
            jObject.add("shift", context.serialize((Object)src.shift));
            jObject.add("cap", context.serialize((Object)src.cap));
            return src.endSerialization(jObject, context);
        }
    }
}

