/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mobspropertiesrandomness.util;

import insane96mcp.mobspropertiesrandomness.module.base.feature.MPRBase;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Logger {
    private static File logFile;
    private static Writer writer;
    private static PrintWriter printWriter;

    public static void init(String filePath) {
        logFile = new File(filePath);
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(logFile), StandardCharsets.UTF_8);
            printWriter = new PrintWriter(writer);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException("Could not create / open log file " + String.valueOf(logFile), ex);
        }
    }

    public static void log(LogType logType, String message, Object ... params) {
        try {
            writer.write(String.format("[%s] [%s] %s %s", new Object[]{new SimpleDateFormat("HH:mm:ss").format(new Date()), logType, String.format(message, params), System.lineSeparator()}));
            writer.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void debug(String message, Object ... params) {
        if (!MPRBase.verboseLog.booleanValue()) {
            return;
        }
        Logger.log(LogType.DEBUG, message, params);
    }

    public static void info(String message, Object ... params) {
        Logger.log(LogType.INFO, message, params);
    }

    public static void warn(String message, Object ... params) {
        Logger.log(LogType.WARN, message, params);
    }

    public static void error(String message, Object ... params) {
        Logger.log(LogType.ERROR, message, params);
    }

    public static String getStackTrace(Exception e) {
        StackTraceElement[] trace;
        StringBuilder r = new StringBuilder();
        r.append(e.toString());
        r.append("\r\n");
        for (StackTraceElement traceElement : trace = e.getStackTrace()) {
            r.append("\tat ").append(traceElement).append("\r\n");
        }
        return r.toString();
    }

    public static enum LogType {
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

