/*
 * Decompiled with CFR 0.152.
 */
package net.noahsimcox.musicinfo;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_7923;

public class DynamicMusicLoader {
    private static final Map<String, class_3414> TRACKS = new HashMap<String, class_3414>();
    private static final Set<class_2960> LOADED_SOUNDS = new HashSet<class_2960>();

    public static void initialize() {
        DynamicMusicLoader.iterateResourcePaths("assets/music-info/sounds/music", (id, path) -> {
            if (path.toString().endsWith(".ogg")) {
                String trackName = path.getFileName().toString().replace(".ogg", "");
                DynamicMusicLoader.registerTrack(trackName);
            }
        });
    }

    private static void registerTrack(String trackName) {
        class_2960 soundId = class_2960.method_60655((String)"music-info", (String)("music.dynamic" + trackName));
        if (!LOADED_SOUNDS.contains(soundId)) {
            class_3414 event = (class_3414)class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)soundId, (Object)class_3414.method_47908((class_2960)soundId));
            TRACKS.put(trackName, event);
            LOADED_SOUNDS.add(soundId);
        }
    }

    public static class_3414 getTrack(String trackName) {
        return TRACKS.get(trackName.toLowerCase());
    }

    public static Set<String> getAvailableTracks() {
        return TRACKS.keySet();
    }

    public static void iterateResourcePaths(String searchPath, ResourceVisitor visitor) {
        try {
            ModContainer mod = (ModContainer)FabricLoader.getInstance().getModContainer("music-info").orElseThrow();
            mod.findPath(searchPath).ifPresent(root -> {
                try (Stream<Path> paths = Files.walk(root, new FileVisitOption[0]);){
                    paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                        String relative = root.relativize((Path)path).toString();
                        class_2960 id = class_2960.method_60655((String)"music-info", (String)relative.replace('\\', '/'));
                        visitor.visit(id, (Path)path);
                    });
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface ResourceVisitor {
        public void visit(class_2960 var1, Path var2);
    }
}

