/*
 * Decompiled with CFR 0.152.
 */
package net.noahsimcox.musicinfo;

import java.util.Map;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.noahsimcox.musicinfo.DynamicMusicLoader;
import net.noahsimcox.musicinfo.MusicInfo;
import net.noahsimcox.musicinfo.PlayMusicPayload;

public class MusicInfoClient
implements ClientModInitializer {
    public static class_1113 currentMusic;
    private static boolean isTracking;
    public static final Map<String, class_3414> VANILLA_TRACKS;

    public void onInitializeClient() {
        ClientPlayNetworking.registerGlobalReceiver(PlayMusicPayload.ID, (payload, context) -> {
            String trackName = payload.trackName().toLowerCase();
            context.client().execute(() -> {
                class_3414 sound = VANILLA_TRACKS.containsKey(trackName) ? VANILLA_TRACKS.get(trackName) : DynamicMusicLoader.getTrack(trackName);
                System.out.println(sound.toString());
                if (sound != null) {
                    class_310 client = class_310.method_1551();
                    float musicVolume = client.field_1690.method_71978(class_3419.field_15253);
                    MusicInfoClient.stopCurrentMusic(client);
                    currentMusic = class_1109.method_4758((class_3414)sound, (float)musicVolume);
                    client.method_1483().method_4873(currentMusic);
                    if (!isTracking) {
                        MusicInfoClient.startPlaybackTracker(client);
                    }
                }
            });
        });
    }

    private static void startPlaybackTracker(class_310 client) {
        isTracking = true;
        new Thread(() -> {
            while (isTracking && client.method_22108()) {
                try {
                    Thread.sleep(500L);
                    client.execute(() -> {
                        if (currentMusic != null && !client.method_1483().method_4877(currentMusic)) {
                            currentMusic = null;
                        }
                        if (currentMusic == null) {
                            isTracking = false;
                        }
                    });
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }).start();
    }

    private static void stopCurrentMusic(class_310 client) {
        client.method_1538().method_4859();
        client.method_1483().method_4875(null, class_3419.field_15253);
        if (currentMusic != null) {
            client.method_1483().method_4870(currentMusic);
            currentMusic = null;
        }
    }

    public static boolean isPlaying() {
        return currentMusic != null;
    }

    static {
        isTracking = false;
        VANILLA_TRACKS = Map.ofEntries(Map.entry("haggstrom", MusicInfo.HAGGSTROM), Map.entry("oxygene", MusicInfo.OXYGENE), Map.entry("danny", MusicInfo.DANNY), Map.entry("aria_math", MusicInfo.ARIA_MATH), Map.entry("dry_hands", MusicInfo.DRY_HANDS), Map.entry("key", MusicInfo.KEY), Map.entry("sweden", MusicInfo.SWEDEN), Map.entry("mice_on_venus", MusicInfo.MICE_ON_VENUS), Map.entry("moog_city_2", MusicInfo.MOOG_CITY_2), Map.entry("end", MusicInfo.END), Map.entry("nether", MusicInfo.NETHER));
    }
}

