/*
 * Decompiled with CFR 0.152.
 */
package pwk.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;

public class AutoWhitelistConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path WHITELIST_CONFIG_FOLDER = Path.of("pwkutils", new String[0]);
    private static final Path WHITELIST_CONFIG_FILE = WHITELIST_CONFIG_FOLDER.resolve("autowhitelistconfig.json");
    public List<String> players = new ArrayList<String>();

    public static AutoWhitelistConfig loadConfig() {
        AutoWhitelistConfig autoWhitelistConfig;
        if (!Files.exists(WHITELIST_CONFIG_FOLDER, new LinkOption[0])) {
            Files.createDirectories(WHITELIST_CONFIG_FOLDER, new FileAttribute[0]);
        }
        if (!Files.exists(WHITELIST_CONFIG_FILE, new LinkOption[0])) {
            AutoWhitelistConfig cfg = new AutoWhitelistConfig();
            cfg.save();
            return cfg;
        }
        FileReader reader = new FileReader(WHITELIST_CONFIG_FILE.toFile());
        try {
            autoWhitelistConfig = (AutoWhitelistConfig)GSON.fromJson((Reader)reader, AutoWhitelistConfig.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                e.printStackTrace();
                return new AutoWhitelistConfig();
            }
        }
        ((Reader)reader).close();
        return autoWhitelistConfig;
    }

    public void save() {
        try (FileWriter writer = new FileWriter(WHITELIST_CONFIG_FILE.toFile());){
            GSON.toJson((Object)this, (Appendable)writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

