/*
 * Decompiled with CFR 0.152.
 */
package pwk.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String DEFAULT_PREFIX_OP = "\u00a74Admin \u00a78| \u00a7c";
    private static final String DEFAULT_PREFIX_NON_OP = "\u00a72Player \u00a78| \u00a7a";
    private static final String DEFAULT_JOIN = "\u00a7a\u00bb \u00a78|\u00a7r {player}";
    private static final String DEFAULT_LEAVE = "\u00a7c\u00ab \u00a78|\u00a7r {player}";
    private static final boolean DEFAULT_CHANGE_JOIN_LEAVE = true;
    private static final String DEFAULT_CHAT_FORMAT = "{player}\u00a78: \u00a77{message}";
    private static final boolean DEFAULT_ALLOW_CHAT_FORMATTING = true;
    private static final boolean DEFAULT_SHOW_WELCOME_MESSAGE = true;
    private static final String DEFAULT_WELCOME = "\u00a77>\u2014\u2014\u2014\u2014\u2014 INFO \u2014\u2014\u2014\u2014\u2014<\n\n\u00a7eWelcome!\n\n\u00a77>\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014<";
    private static final String DEFAULT_TABLIST_HEADER = "\u00a73This is a header!\n\u00a77>\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014<";
    private static final String DEFAULT_TABLIST_FOOTER = "\u00a77>\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014<\u00a76\nThank you for using \u00a73\u00a7lPWKUtils\u00a76!";
    private static final boolean DEFAULT_SHOW_ONLINE_PLAYERS = true;
    private static String prefixOp = "\u00a74Admin \u00a78| \u00a7c";
    private static String prefixNonOp = "\u00a72Player \u00a78| \u00a7a";
    private static String joinMessage = "\u00a7a\u00bb \u00a78|\u00a7r {player}";
    private static String leaveMessage = "\u00a7c\u00ab \u00a78|\u00a7r {player}";
    private static boolean changeJoinLeave = true;
    private static String chatFormat = "{player}\u00a78: \u00a77{message}";
    private static boolean allowChatFormatting = true;
    private static String welcomeMessage = "\u00a77>\u2014\u2014\u2014\u2014\u2014 INFO \u2014\u2014\u2014\u2014\u2014<\n\n\u00a7eWelcome!\n\n\u00a77>\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014<";
    private static boolean showWelcomeMessage = true;
    private static String tablistHeader = "\u00a73This is a header!\n\u00a77>\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014<";
    private static String tablistFooter = "\u00a77>\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014<\u00a76\nThank you for using \u00a73\u00a7lPWKUtils\u00a76!";
    private static boolean showOnlinePlayers = true;
    private static final String CONFIG_FOLDER = "pwkutils";
    private static final String CONFIG_FILE_NAME = "config.json";

    public static void loadConfig() {
        try {
            File configFile;
            File folder = new File(CONFIG_FOLDER);
            if (!folder.exists() && !folder.mkdirs()) {
                System.err.println("Fehler beim Erstellen des Config-Ordners: " + folder.getAbsolutePath());
            }
            if (!(configFile = new File(folder, CONFIG_FILE_NAME)).exists()) {
                JsonObject defaultJson = new JsonObject();
                defaultJson.addProperty("prefixOp", DEFAULT_PREFIX_OP);
                defaultJson.addProperty("prefixNonOp", DEFAULT_PREFIX_NON_OP);
                defaultJson.addProperty("changeJoinLeaveMessage", Boolean.valueOf(true));
                defaultJson.addProperty("joinMessage", DEFAULT_JOIN);
                defaultJson.addProperty("leaveMessage", DEFAULT_LEAVE);
                defaultJson.addProperty("allowChatFormatting", Boolean.valueOf(true));
                defaultJson.addProperty("chatFormat", DEFAULT_CHAT_FORMAT);
                defaultJson.addProperty("showWelcomeMessage", Boolean.valueOf(true));
                defaultJson.addProperty("welcomeMessage", DEFAULT_WELCOME);
                defaultJson.addProperty("tablistHeader", DEFAULT_TABLIST_HEADER);
                defaultJson.addProperty("tablistFooter", DEFAULT_TABLIST_FOOTER);
                defaultJson.addProperty("showOnlinePlayers", Boolean.valueOf(true));
                try (FileWriter writer = new FileWriter(configFile);){
                    GSON.toJson((JsonElement)defaultJson, (Appendable)writer);
                }
                System.out.println("Default Config erstellt: " + configFile.getAbsolutePath());
            }
            try (FileReader reader = new FileReader(configFile);){
                JsonObject json = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                if (json.has("prefixOp")) {
                    prefixOp = json.get("prefixOp").getAsString();
                }
                if (json.has("prefixNonOp")) {
                    prefixNonOp = json.get("prefixNonOp").getAsString();
                }
                if (json.has("changeJoinLeaveMessage")) {
                    changeJoinLeave = json.get("changeJoinLeaveMessage").getAsBoolean();
                }
                if (json.has("joinMessage")) {
                    joinMessage = json.get("joinMessage").getAsString();
                }
                if (json.has("leaveMessage")) {
                    leaveMessage = json.get("leaveMessage").getAsString();
                }
                if (json.has("allowChatFormatting")) {
                    allowChatFormatting = json.get("allowChatFormatting").getAsBoolean();
                }
                if (json.has("chatFormat")) {
                    chatFormat = json.get("chatFormat").getAsString();
                }
                if (json.has("showWelcomeMessage")) {
                    showWelcomeMessage = json.get("showWelcomeMessage").getAsBoolean();
                }
                if (json.has("welcomeMessage")) {
                    welcomeMessage = json.get("welcomeMessage").getAsString();
                }
                if (json.has("tablistHeader")) {
                    tablistHeader = json.get("tablistHeader").getAsString();
                }
                if (json.has("tablistFooter")) {
                    tablistFooter = json.get("tablistFooter").getAsString();
                }
                if (json.has("showOnlinePlayers")) {
                    showOnlinePlayers = json.get("showOnlinePlayers").getAsBoolean();
                }
            }
        }
        catch (IOException e) {
            System.err.println("Fehler beim Laden der Config: " + e.getMessage());
        }
    }

    public static boolean shouldChangeJoinLeave() {
        return changeJoinLeave;
    }

    public static String getJoinMessage(String playerName) {
        return joinMessage.replace("{player}", playerName);
    }

    public static String getLeaveMessage(String playerName) {
        return leaveMessage.replace("{player}", playerName);
    }

    public static boolean isChatFormattingAllowed() {
        return allowChatFormatting;
    }

    public static String getChatFormat(String playerName, String message) {
        return chatFormat.replace("{player}", playerName).replace("{message}", message);
    }

    public static String getTablistHeader() {
        return tablistHeader;
    }

    public static String getTablistFooter(int online, int max) {
        if (showOnlinePlayers) {
            return tablistFooter + "\n\u00a75\u00a7lOnline: \u00a7a" + online + "\u00a77/\u00a72" + max;
        }
        return tablistFooter;
    }

    public static boolean shouldShowOnlinePlayers() {
        return showOnlinePlayers;
    }

    public static String getOpPrefix() {
        return prefixOp;
    }

    public static String getNonOpPrefix() {
        return prefixNonOp;
    }

    public static String getWelcomeMessage() {
        return welcomeMessage;
    }

    public static boolean shouldShowWelcomeMessage() {
        return showWelcomeMessage;
    }
}

