/*
 * Decompiled with CFR 0.152.
 */
package pwk.utils;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;

public class LocalizationManager {
    private static final Gson GSON = new Gson();
    private static JsonObject data;
    private static final File EXTERNAL_FILE;
    private static final String PREFIX = "\u00a78[\u00a73PWKUtils\u00a78] \u00a77";

    public static void load() {
        try {
            if (!EXTERNAL_FILE.exists()) {
                EXTERNAL_FILE.getParentFile().mkdirs();
                try (InputStream stream = LocalizationManager.class.getClassLoader().getResourceAsStream("assets/pwkutils/messages.json");){
                    if (stream == null) {
                        System.err.println("[PWKUtils] Default messages.json not found in mod!");
                        data = new JsonObject();
                        return;
                    }
                    try (FileOutputStream out = new FileOutputStream(EXTERNAL_FILE);){
                        stream.transferTo(out);
                        System.out.println("[PWKUtils] Created external messages.json on the server.");
                    }
                }
            }
            try (FileReader reader = new FileReader(EXTERNAL_FILE);){
                data = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                System.out.println("[PWKUtils] Loaded messages.json from server folder.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String get(String key, Object ... args) {
        if (data == null || !data.has(key)) {
            return PREFIX + key;
        }
        String msg = String.format(data.get(key).getAsString(), args);
        return PREFIX + msg;
    }

    static {
        EXTERNAL_FILE = new File("pwkutils/messages.json");
    }
}

