/*
 * Decompiled with CFR 0.152.
 */
package pwk.utils;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pwk.utils.AutoWhitelistConfig;
import pwk.utils.ConfigManager;
import pwk.utils.LocalizationManager;
import pwk.utils.PrefixManager;
import pwk.utils.TablistManager;
import pwk.utils.WelcomeMessageManager;
import pwk.utils.commands.AutoWhitelistCommand;
import pwk.utils.commands.GamemodeCommand;
import pwk.utils.commands.TPSCommand;

public class PWKUtils
implements ModInitializer {
    public static final String MOD_ID = "pwkutils";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"pwkutils");
    public static final PrefixManager PREFIX_MANAGER = new PrefixManager();

    public void onInitialize() {
        ConfigManager.loadConfig();
        AutoWhitelistConfig.loadConfig();
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.field_14140;
            PREFIX_MANAGER.applyPrefix(player);
        });
        GamemodeCommand.registerCommands();
        TPSCommand.registerCommands();
        AutoWhitelistCommand.registerCommands();
        new WelcomeMessageManager();
        LocalizationManager.load();
        LOGGER.info("[PWKUtils] Mod initialized.");
        ServerLifecycleEvents.SERVER_STARTED.register(this::onServerStarted);
    }

    private void onServerStarted(MinecraftServer server) {
        TablistManager.start(server);
    }
}

