/*
 * Decompiled with CFR 0.152.
 */
package pwk.utils.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3330;
import net.minecraft.class_3340;
import net.minecraft.server.MinecraftServer;
import pwk.utils.AutoWhitelistConfig;
import pwk.utils.LocalizationManager;

public class AutoWhitelistCommand {
    public static void registerCommands() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"autowhitelist").requires(src -> src.method_9259(2))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            for (class_3222 p : ((class_2168)context.getSource()).method_9211().method_3760().method_14571()) {
                builder.suggest(p.method_7334().getName());
            }
            return CompletableFuture.completedFuture(builder.build());
        }).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            AutoWhitelistConfig cfg = AutoWhitelistConfig.loadConfig();
            if (!cfg.players.contains(name)) {
                cfg.players.add(name);
                cfg.save();
            }
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)LocalizationManager.get("command.autowhitelist.add", name)));
            return 1;
        })))).then(class_2170.method_9247((String)"list").executes(ctx -> {
            AutoWhitelistConfig cfg = AutoWhitelistConfig.loadConfig();
            if (cfg.players.isEmpty()) {
                ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)LocalizationManager.get("command.autowhitelist.list.empty", new Object[0])));
                return 1;
            }
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)LocalizationManager.get("command.autowhitelist.list.header", new Object[0])));
            for (String name : cfg.players) {
                ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)("\u00a77 - \u00a7a" + name)));
            }
            return 1;
        }))).then(class_2170.method_9247((String)"clear").executes(ctx -> {
            AutoWhitelistConfig cfg = AutoWhitelistConfig.loadConfig();
            int size = cfg.players.size();
            cfg.players.clear();
            cfg.save();
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)LocalizationManager.get("command.autowhitelist.clear", size)));
            return 1;
        }))).then(class_2170.method_9247((String)"run").executes(ctx -> {
            AutoWhitelistConfig cfg = AutoWhitelistConfig.loadConfig();
            MinecraftServer server = ((class_2168)ctx.getSource()).method_9211();
            int count = 0;
            for (String playerName : cfg.players) {
                Optional profile = server.method_3793().method_14515(playerName);
                if (profile.isEmpty()) {
                    ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)LocalizationManager.get("command.autowhitelist.run.notfound", playerName)));
                    continue;
                }
                class_3340 entry = new class_3340((GameProfile)profile.get());
                server.method_3760().method_14590().method_14633((class_3330)entry);
                ++count;
            }
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)LocalizationManager.get("command.autowhitelist.run.success", count)));
            return 1;
        }))));
    }
}

