/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.weirdcommands.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mrbysco.weirdcommands.commands.Perspective;
import com.mrbysco.weirdcommands.network.message.SetEffectPayload;
import com.mrbysco.weirdcommands.network.message.SetLanguagePayload;
import com.mrbysco.weirdcommands.network.message.SetPerspectivePayload;
import com.mrbysco.weirdcommands.network.message.SetRandomEffectPayload;
import com.mrbysco.weirdcommands.network.message.SetSmoothCameraPayload;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.server.command.EnumArgument;

public class ModCommands {
    public static final List<String> languages = new ArrayList<String>(List.of("en_us"));
    public static final List<ResourceLocation> effects = Lists.newArrayList();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder root = Commands.literal((String)"weirdcommands");
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)root.requires(sourceStack -> sourceStack.hasPermission(2))).then(Commands.literal((String)"lang").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"id", (ArgumentType)StringArgumentType.word()).suggests((cs, builder) -> SharedSuggestionProvider.suggest(languages, (SuggestionsBuilder)builder)).executes(ModCommands::setLanguage))))).then(Commands.literal((String)"effect").then(((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"id", (ArgumentType)ResourceLocationArgument.id()).suggests((cs, builder) -> {
            ArrayList values = Lists.newArrayList();
            effects.forEach(effect -> values.add(effect.toString()));
            return SharedSuggestionProvider.suggest((Iterable)values, (SuggestionsBuilder)builder);
        }).executes(ModCommands::setEffect))).then(Commands.literal((String)"clear").executes(ModCommands::clearEffect))))).then(Commands.literal((String)"randomEffect").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).executes(ModCommands::setRandomEffect)))).then(Commands.literal((String)"perspective").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"perspective", (ArgumentType)EnumArgument.enumArgument(Perspective.class)).executes(ModCommands::setPerspective))))).then(Commands.literal((String)"smoothCamera").then(Commands.argument((String)"players", (ArgumentType)EntityArgument.players()).then(Commands.argument((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(ModCommands::setSmoothCamera))));
        dispatcher.register(root);
    }

    private static int setLanguage(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String langID = StringArgumentType.getString(context, (String)"id");
        Collection players = EntityArgument.getPlayers(context, (String)"players");
        for (ServerPlayer player : players) {
            player.connection.send((CustomPacketPayload)new SetLanguagePayload(langID));
        }
        MutableComponent component = Component.literal((String)langID).withStyle(ChatFormatting.GOLD);
        if (players.size() == 1) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"weirdcommands.commands.language.set.success.single", (Object[])new Object[]{component, ((ServerPlayer)players.iterator().next()).getName()}).withStyle(ChatFormatting.YELLOW), true);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"weirdcommands.commands.language.set.success.multiple", (Object[])new Object[]{component, players.size()}).withStyle(ChatFormatting.YELLOW), true);
        }
        return 0;
    }

    private static int setEffect(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ResourceLocation effectID = ResourceLocationArgument.getId(context, (String)"id");
        Collection players = EntityArgument.getPlayers(context, (String)"players");
        for (ServerPlayer player : players) {
            player.connection.send((CustomPacketPayload)new SetEffectPayload(effectID));
        }
        MutableComponent component = Component.literal((String)effectID.toString()).withStyle(ChatFormatting.GOLD);
        if (players.size() == 1) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"weirdcommands.commands.effect.set.success.single", (Object[])new Object[]{component, ((ServerPlayer)players.iterator().next()).getName()}).withStyle(ChatFormatting.YELLOW), true);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"weirdcommands.commands.effect.set.success.multiple", (Object[])new Object[]{component, players.size()}).withStyle(ChatFormatting.YELLOW), true);
        }
        return 0;
    }

    private static int clearEffect(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.getPlayers(context, (String)"players");
        for (ServerPlayer player : players) {
            player.connection.send((CustomPacketPayload)new SetEffectPayload((ResourceLocation)null));
        }
        if (players.size() == 1) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"weirdcommands.commands.effect.clear.success.single", (Object[])new Object[]{((ServerPlayer)players.iterator().next()).getName()}).withStyle(ChatFormatting.YELLOW), true);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"weirdcommands.commands.effect.clear.success.multiple", (Object[])new Object[]{players.size()}).withStyle(ChatFormatting.YELLOW), true);
        }
        return 0;
    }

    private static int setRandomEffect(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection players = EntityArgument.getPlayers(context, (String)"players");
        for (ServerPlayer player : players) {
            player.connection.send((CustomPacketPayload)new SetRandomEffectPayload());
        }
        if (players.size() == 1) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"weirdcommands.commands.effect.random.success.single", (Object[])new Object[]{((ServerPlayer)players.iterator().next()).getName()}).withStyle(ChatFormatting.YELLOW), true);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"weirdcommands.commands.effect.random.success.multiple", (Object[])new Object[]{players.size()}).withStyle(ChatFormatting.YELLOW), true);
        }
        return 0;
    }

    private static int setPerspective(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Perspective perspective = (Perspective)((Object)context.getArgument("perspective", Perspective.class));
        Collection players = EntityArgument.getPlayers(context, (String)"players");
        for (ServerPlayer player : players) {
            player.connection.send((CustomPacketPayload)new SetPerspectivePayload(perspective));
        }
        MutableComponent component = Component.literal((String)perspective.getPerspectiveName()).withStyle(ChatFormatting.GOLD);
        if (players.size() == 1) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"weirdcommands.commands.perspective.set.success.single", (Object[])new Object[]{component, ((ServerPlayer)players.iterator().next()).getName()}).withStyle(ChatFormatting.YELLOW), true);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"weirdcommands.commands.perspective.set.success.multiple", (Object[])new Object[]{component, players.size()}).withStyle(ChatFormatting.YELLOW), true);
        }
        return 0;
    }

    private static int setSmoothCamera(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        boolean enabled = BoolArgumentType.getBool(context, (String)"enabled");
        Collection players = EntityArgument.getPlayers(context, (String)"players");
        for (ServerPlayer player : players) {
            player.connection.send((CustomPacketPayload)new SetSmoothCameraPayload(enabled));
        }
        MutableComponent component = Component.literal((String)String.valueOf(enabled)).withStyle(ChatFormatting.GOLD);
        if (players.size() == 1) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"weirdcommands.commands.smooth_camera.set.success.single", (Object[])new Object[]{component, ((ServerPlayer)players.iterator().next()).getName()}).withStyle(ChatFormatting.YELLOW), true);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"weirdcommands.commands.smooth_camera.set.success.multiple", (Object[])new Object[]{component, players.size()}).withStyle(ChatFormatting.YELLOW), true);
        }
        return 0;
    }
}

