/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.weirdcommands.network.handler;

import com.mrbysco.weirdcommands.client.ClientHandler;
import com.mrbysco.weirdcommands.network.message.SetEffectPayload;
import com.mrbysco.weirdcommands.network.message.SetLanguagePayload;
import com.mrbysco.weirdcommands.network.message.SetPerspectivePayload;
import com.mrbysco.weirdcommands.network.message.SetRandomEffectPayload;
import com.mrbysco.weirdcommands.network.message.SetSmoothCameraPayload;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.LanguageInfo;
import net.minecraft.client.resources.language.LanguageManager;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ClientPayloadHandler {
    private static final ClientPayloadHandler INSTANCE = new ClientPayloadHandler();

    public static ClientPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleEffectData(SetEffectPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Minecraft minecraft = Minecraft.getInstance();
            if (payload.effect() == null) {
                minecraft.gameRenderer.clearPostEffect();
            } else {
                minecraft.gameRenderer.setPostEffect(payload.effect());
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"weirdcommands.networking.set_effect.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public void handleLangData(SetLanguagePayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Minecraft minecraft = Minecraft.getInstance();
            LanguageManager languageManager = minecraft.getLanguageManager();
            LanguageInfo languageInfo = languageManager.getLanguage(payload.language());
            if (languageInfo != null) {
                languageManager.setSelected(payload.language());
            }
            minecraft.reloadResourcePacks();
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"weirdcommands.networking.set_language.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public void handlePerspectiveData(SetPerspectivePayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Minecraft minecraft = Minecraft.getInstance();
            switch (payload.perspective()) {
                default: {
                    minecraft.options.setCameraType(CameraType.FIRST_PERSON);
                    break;
                }
                case THIRD_PERSON_BACK: {
                    minecraft.options.setCameraType(CameraType.THIRD_PERSON_BACK);
                    break;
                }
                case THIRD_PERSON_FRONT: {
                    minecraft.options.setCameraType(CameraType.THIRD_PERSON_FRONT);
                }
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"weirdcommands.networking.set_perspective.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public void handleRandomEffectData(SetRandomEffectPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Minecraft minecraft = Minecraft.getInstance();
            ClientHandler.setRandomEffect(minecraft.gameRenderer);
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"weirdcommands.networking.set_random_effect.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public void handleSmoothCameraData(SetSmoothCameraPayload payload, IPayloadContext context) {
        context.enqueueWork(() -> {
            Minecraft minecraft = Minecraft.getInstance();
            minecraft.options.smoothCamera = payload.enabled();
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"weirdcommands.networking.set_smooth_camera.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

