/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.weirdcommands.client;

import com.mrbysco.weirdcommands.network.message.EffectsToServerPayload;
import com.mrbysco.weirdcommands.network.message.LangsToServerPayload;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.compress.utils.Lists;

@EventBusSubscriber(modid="weirdcommands", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class ClientHandler {
    static final Random RANDOM = new Random();
    static final List<ResourceLocation> EFFECTS = new ArrayList<ResourceLocation>();

    @SubscribeEvent
    public static void onLogin(ClientPlayerNetworkEvent.LoggingIn event) {
        if (Minecraft.getInstance().getConnection() != null) {
            ClientHandler.syncValues();
        }
    }

    public static void syncValues() {
        ArrayList languages = Lists.newArrayList();
        Minecraft mc = Minecraft.getInstance();
        mc.getLanguageManager().getLanguages().forEach((language, languageInfo) -> languages.add(language));
        PacketDistributor.sendToServer((CustomPacketPayload)new LangsToServerPayload(languages), (CustomPacketPayload[])new CustomPacketPayload[0]);
        EFFECTS.clear();
        EFFECTS.add(ResourceLocation.withDefaultNamespace((String)"creeper"));
        EFFECTS.add(ResourceLocation.withDefaultNamespace((String)"spider"));
        EFFECTS.add(ResourceLocation.withDefaultNamespace((String)"invert"));
        PacketDistributor.sendToServer((CustomPacketPayload)new EffectsToServerPayload(EFFECTS), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void setRandomEffect(GameRenderer gameRenderer) {
        if (gameRenderer.getMinecraft().getCameraEntity() instanceof Player) {
            if (gameRenderer.currentPostEffect() != null) {
                gameRenderer.clearPostEffect();
            }
            gameRenderer.setPostEffect(EFFECTS.get(RANDOM.nextInt(EFFECTS.size())));
        }
    }
}

