/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.ClassDiscoverer;
import codechicken.core.ClientUtils;
import codechicken.core.GuiModListScroll;
import codechicken.lib.packet.PacketCustom;
import codechicken.nei.AutoFocusWidget;
import codechicken.nei.DefaultHighlightHandler;
import codechicken.nei.HUDRenderer;
import codechicken.nei.ItemCraftablesPanel;
import codechicken.nei.ItemMobSpawner;
import codechicken.nei.KeyManager;
import codechicken.nei.NEICPH;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.NEIController;
import codechicken.nei.NEIModContainer;
import codechicken.nei.WorldOverlayRenderer;
import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.api.ItemInfo;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipeTab;
import codechicken.nei.recipe.StackInfo;
import com.google.common.collect.Lists;
import cpw.mods.fml.client.CustomModLoadingErrorDisplayException;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModClassLoader;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiErrorScreen;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSelectWorld;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.resources.IResource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import org.apache.commons.io.IOUtils;

public class ClientHandler {
    private static ClientHandler instance;
    private final ArrayList<EntityItem> SMPmagneticItems = new ArrayList();
    private World lastworld;

    public void addSMPMagneticItem(int i, World world) {
        WorldClient cworld = (WorldClient)world;
        Entity e = cworld.getEntityByID(i);
        if (!(e instanceof EntityItem)) {
            return;
        }
        this.SMPmagneticItems.add((EntityItem)e);
    }

    private void updateMagnetMode(World world, EntityPlayerSP player) {
        if (!NEIClientConfig.getMagnetMode()) {
            return;
        }
        float distancexz = 16.0f;
        float distancey = 8.0f;
        double maxspeedxz = 0.5;
        double maxspeedy = 0.5;
        double speedxz = 0.05;
        double speedy = 0.07;
        List<Object> items = world.isRemote ? this.SMPmagneticItems : world.getEntitiesWithinAABB(EntityItem.class, player.boundingBox.expand((double)distancexz, (double)distancey, (double)distancexz));
        Iterator iterator = items.iterator();
        while (iterator.hasNext()) {
            double rationspeedy;
            EntityItem item = (EntityItem)iterator.next();
            if (item.delayBeforeCanPickup > 0) continue;
            if (item.isDead && world.isRemote) {
                iterator.remove();
            }
            if (!NEIClientUtils.canItemFitInInventory((EntityPlayer)player, item.getEntityItem())) continue;
            double dx = player.posX - item.posX;
            double dy = player.posY + (double)player.getEyeHeight() - item.posY;
            double dz = player.posZ - item.posZ;
            double absxz = Math.sqrt(dx * dx + dz * dz);
            double absy = Math.abs(dy);
            if (absxz > (double)distancexz) continue;
            if (absxz > 1.0) {
                dx /= absxz;
                dz /= absxz;
            }
            if (absy > 1.0) {
                dy /= absy;
            }
            double vx = item.motionX + speedxz * dx;
            double vy = item.motionY + speedy * dy;
            double vz = item.motionZ + speedxz * dz;
            double absvxz = Math.sqrt(vx * vx + vz * vz);
            double absvy = Math.abs(vy);
            double rationspeedxz = absvxz / maxspeedxz;
            if (rationspeedxz > 1.0) {
                vx /= rationspeedxz;
                vz /= rationspeedxz;
            }
            if ((rationspeedy = absvy / maxspeedy) > 1.0) {
                vy /= rationspeedy;
            }
            if (absvxz < 0.2 && absxz < 0.2 && world.isRemote) {
                item.setDead();
            }
            item.setVelocity(vx, vy, vz);
        }
    }

    public static void preInit() {
        ClientHandler.loadSerialHandlers();
        ClientHandler.loadHiddenItems();
        ClientHandler.loadHeightHackHandlers();
        ClientHandler.loadHiddenHandlers();
        ClientHandler.loadEnableAutoFocus();
        ClientHandler.loadGuiCraftablesBlacklist();
        ItemInfo.preInit();
        StackInfo.loadGuidFilters();
    }

    public static void loadSettingsFile(String resource, Consumer<Stream<String>> callback) {
        ClientHandler.loadSettingsFile(resource, (file, writer) -> {
            String folder = resource.substring(resource.lastIndexOf(".") + 1);
            URL defaultResource = ClientHandler.class.getResource("/assets/nei/" + folder + "/" + resource);
            if (defaultResource != null) {
                try {
                    IOUtils.copy((InputStream)defaultResource.openStream(), (Writer)writer);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }, callback);
    }

    public static boolean loadSettingsResource(String resource, Consumer<Stream<String>> callback) {
        boolean bl;
        ResourceLocation location = new ResourceLocation("nei", resource);
        IResource res = Minecraft.getMinecraft().getResourceManager().getResource(location);
        BufferedReader reader = new BufferedReader(new InputStreamReader(res.getInputStream(), StandardCharsets.UTF_8));
        try {
            NEIClientConfig.logger.info("Loading '{}' from jar {}", new Object[]{resource, location});
            callback.accept(IOUtils.readLines((Reader)reader).stream().map(String::trim).filter(line -> !line.isEmpty() && !line.startsWith("#")));
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception io) {
                NEIClientConfig.logger.error("Failed to load '{}' file {}", new Object[]{resource, location});
                return false;
            }
        }
        reader.close();
        return bl;
    }

    public static boolean loadSettingsFile(String resource, BiConsumer<File, FileWriter> createDefault, Consumer<Stream<String>> callback) {
        File file = new File(NEIClientConfig.configDir, resource);
        if (!file.exists() && createDefault != null) {
            try (FileWriter writer = new FileWriter(file);){
                NEIClientConfig.logger.info("Creating default '{}' {}", new Object[]{resource, file});
                createDefault.accept(file, writer);
            }
            catch (IOException e) {
                NEIClientConfig.logger.error("Failed to save default '{}' to file {}", new Object[]{resource, file, e});
            }
        }
        if (file.exists()) {
            boolean bl;
            FileReader reader = new FileReader(file);
            try {
                NEIClientConfig.logger.info("Loading '{}' file {}", new Object[]{resource, file});
                callback.accept(IOUtils.readLines((Reader)reader).stream().map(String::trim).filter(line -> !line.isEmpty() && !line.startsWith("#")));
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    NEIClientConfig.logger.error("Failed to load '{}' file {}", new Object[]{resource, file, e});
                }
            }
            reader.close();
            return bl;
        }
        return false;
    }

    public static void loadSerialHandlers() {
        ClientHandler.loadSettingsFile("serialhandlers.cfg", lines -> {
            NEIClientConfig.serialHandlers = lines.collect(Collectors.toCollection(HashSet::new));
        });
    }

    public static void loadHeightHackHandlers() {
        ClientHandler.loadSettingsFile("heighthackhandlers.cfg", lines -> {
            NEIClientConfig.heightHackHandlerRegex = lines.map(Pattern::compile).collect(Collectors.toCollection(HashSet::new));
        });
    }

    public static void loadHiddenHandlers() {
        ClientHandler.loadSettingsFile("hiddenhandlers.cfg", lines -> {
            NEIClientConfig.hiddenHandlers = lines.collect(Collectors.toCollection(HashSet::new));
        });
    }

    public static void loadEnableAutoFocus() {
        ClientHandler.loadSettingsFile("enableautofocus.cfg", lines -> {
            AutoFocusWidget.enableAutoFocusPrefixes = lines.collect(Collectors.toList());
        });
    }

    public static void loadGuiCraftablesBlacklist() {
        ClientHandler.loadSettingsFile("guicraftablesblacklist.cfg", lines -> {
            ItemCraftablesPanel.guiBlacklist = lines.collect(Collectors.toList());
        });
    }

    public static void loadHiddenItems() {
        ClientHandler.loadSettingsFile("hiddenitems.cfg", lines -> lines.forEach(API::hideItem));
    }

    public static void load() {
        instance = new ClientHandler();
        GuiModListScroll.register((Object)"NotEnoughItems");
        PacketCustom.assignHandler((Object)"NEI", (PacketCustom.ICustomPacketHandler)new NEICPH());
        FMLCommonHandler.instance().bus().register((Object)instance);
        MinecraftForge.EVENT_BUS.register((Object)instance);
        API.registerHighlightHandler(new DefaultHighlightHandler(), ItemInfo.Layout.HEADER);
        HUDRenderer.load();
        WorldOverlayRenderer.load();
    }

    public static void postInit() {
        GuiContainerManager.registerReloadResourceListener();
    }

    public static void loadHandlerOrdering() {
        String COMMA_DELIMITER = ",";
        String[] defaultHandlerOrdering = new String[]{"# Each line in this file should either be a comment (starts with '#') or an ordering.", "# Ordering lines are <handler ID>,<ordering number>.", "# Handlers will be sorted in order of number ascending, so smaller numbers first.", "# Any handlers that are missing from this file will be assigned to 0.", "# Negative numbers are fine.", "# If you delete this file, it will be regenerated with all registered handler IDs."};
        ClientHandler.loadSettingsFile("handlerordering.csv", (file, writer) -> {
            ArrayList toWrite = Lists.newArrayList((Object[])defaultHandlerOrdering);
            GuiRecipeTab.handlerMap.keySet().stream().sorted().forEach(handlerId -> toWrite.add(String.format("%s,0", handlerId)));
            try {
                IOUtils.writeLines((Collection)toWrite, (String)"\n", (Writer)writer);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }, lines -> lines.map(line -> line.split(",")).filter(parts -> ((String[])parts).length == 2).forEach(parts -> {
            String handlerId = parts[0];
            int ordering = Integer.parseInt(parts[1]);
            NEIClientConfig.handlerOrdering.put(handlerId, ordering);
        }));
    }

    public static void loadPluginsList() {
        boolean jarjar;
        boolean bl = jarjar = Launch.blackboard.getOrDefault("jarjar.rfbPluginLoaded", Boolean.FALSE) == Boolean.TRUE;
        if (!jarjar) {
            ClassDiscoverer classDiscoverer = new ClassDiscoverer(test -> test.startsWith("NEI") && test.endsWith("Config.class"), new Class[]{IConfigureNEI.class});
            NEIClientConfig.pluginsList.addAll(classDiscoverer.findClasses());
            NEIClientConfig.logger.info("Loading NEI Plugins via ClassDiscoverer: " + NEIClientConfig.pluginsList.size());
        } else {
            ASMDataTable dataTable = NEIModContainer.getAsmDataTable();
            ModClassLoader modClassLoader = (ModClassLoader)Loader.instance().getModClassLoader();
            for (ASMDataTable.ASMData asmData : dataTable.getAll(IConfigureNEI.class.getName().replace('.', '/'))) {
                String className = asmData.getClassName().replace('/', '.');
                try {
                    NEIClientConfig.pluginsList.add(Class.forName(className, true, (ClassLoader)modClassLoader));
                }
                catch (ClassNotFoundException e) {
                    NEIClientConfig.logger.error("Failed to load plugin class {}", new Object[]{className, e});
                }
            }
            NEIClientConfig.logger.info("Loading NEI Plugins via JarJar: " + NEIClientConfig.pluginsList.size());
        }
    }

    @SubscribeEvent
    public void tickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.getMinecraft();
        if (mc.theWorld != null) {
            this.loadWorld((World)mc.theWorld, false);
            if (!NEIClientConfig.isEnabled()) {
                return;
            }
            if (NEIClientConfig.isLoaded()) {
                KeyManager.tickKeyStates();
            }
            NEIController.updateUnlimitedItems(mc.thePlayer.inventory);
            if (mc.currentScreen == null) {
                NEIController.processCreativeCycling(mc.thePlayer.inventory);
            }
            this.updateMagnetMode((World)mc.theWorld, (EntityPlayerSP)mc.thePlayer);
        } else {
            this.lastworld = null;
        }
    }

    @SubscribeEvent
    public void onGuiScreen(GuiOpenEvent event) {
        if (event.gui instanceof GuiSelectWorld) {
            NEIClientConfig.reloadSaves();
        } else if (event.gui == null) {
            NEIController.manager = null;
        }
    }

    @SubscribeEvent
    public void tickEvent(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END && NEIClientConfig.isEnabled()) {
            HUDRenderer.renderOverlay();
        }
    }

    @SubscribeEvent
    public void renderLastEvent(RenderWorldLastEvent event) {
        if (NEIClientConfig.isEnabled()) {
            WorldOverlayRenderer.render(event.partialTicks);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        Minecraft mc = Minecraft.getMinecraft();
        if (event.world == mc.theWorld) {
            NEIClientConfig.unloadWorld();
            ItemMobSpawner.clearEntityReferences();
        }
    }

    public void loadWorld(World world, boolean fromServer) {
        if (world != this.lastworld) {
            this.SMPmagneticItems.clear();
            if (!NEIClientConfig.getBooleanSetting("world.overlays.lock")) {
                WorldOverlayRenderer.reset();
            }
            if (!fromServer) {
                NEIClientConfig.setHasSMPCounterPart(false);
                NEIClientConfig.setInternalEnabled(false);
                if (!Minecraft.getMinecraft().isSingleplayer()) {
                    NEIClientConfig.loadWorld("remote/" + ClientUtils.getServerIP().replace(':', '~'));
                }
            }
            this.lastworld = world;
        }
    }

    public static ClientHandler instance() {
        return instance;
    }

    public static RuntimeException throwCME(final String message) {
        GuiErrorScreen errorGui = new GuiErrorScreen(null, null){

            public void handleMouseInput() {
            }

            public void handleKeyboardInput() {
            }

            public void drawScreen(int par1, int par2, float par3) {
                this.drawDefaultBackground();
                String[] s_msg = message.split("\n");
                for (int i = 0; i < s_msg.length; ++i) {
                    this.drawCenteredString(this.fontRendererObj, s_msg[i], this.width / 2, this.height / 3 + 12 * i, -1);
                }
            }
        };
        CustomModLoadingErrorDisplayException e = new CustomModLoadingErrorDisplayException((GuiScreen)errorGui){
            private static final long serialVersionUID = -5593387489666663375L;
            final /* synthetic */ GuiScreen val$errorGui;
            {
                this.val$errorGui = guiScreen;
            }

            public void initGui(GuiErrorScreen errorScreen, FontRenderer fontRenderer) {
                Minecraft.getMinecraft().displayGuiScreen(this.val$errorGui);
            }

            public void drawScreen(GuiErrorScreen errorScreen, FontRenderer fontRenderer, int mouseRelX, int mouseRelY, float tickTime) {
            }
        };
        throw e;
    }
}

