/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.bookmark;

import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.BookmarkPanel;
import codechicken.nei.ItemsGrid;
import codechicken.nei.bookmark.BookmarkGrid;
import codechicken.nei.bookmark.BookmarkGroup;
import codechicken.nei.bookmark.BookmarkItem;
import codechicken.nei.bookmark.BookmarksGridSlot;
import codechicken.nei.bookmark.RecipeChainDetails;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.Recipe;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class SortableItem {
    public final BookmarkGrid grid;
    public final BookmarkItem bookmarkItem;
    public final boolean moveRecipe;
    public final boolean crossGroup;
    public final boolean isCollapsedRecipe;
    public List<Integer> items = new ArrayList<Integer>();
    public int shiftX = -8;
    public int shiftY = -8;

    public SortableItem(BookmarkGrid grid, BookmarkItem bookmarkItem) {
        BookmarkGroup group = grid.getGroup(bookmarkItem.groupId);
        this.grid = grid;
        this.bookmarkItem = bookmarkItem.copy();
        this.moveRecipe = bookmarkItem.recipeId != null && !bookmarkItem.isIngredient && (group.viewMode == BookmarkPanel.BookmarkViewMode.TODO_LIST || group.crafting != null);
        this.crossGroup = !group.collapsed && group.viewMode == BookmarkPanel.BookmarkViewMode.TODO_LIST && !this.bookmarkItem.isIngredient;
        this.isCollapsedRecipe = group.crafting != null && group.crafting.itemToRecipe.values().stream().anyMatch(recipeId -> this.bookmarkItem.equalsRecipe((Recipe.RecipeId)recipeId, this.bookmarkItem.groupId));
        this.update();
    }

    public void postDraw(int mousex, int mousey) {
        Point startRect = null;
        GuiContainerManager.drawItems.zLevel += 100.0f;
        for (Integer itemIndex : this.grid.getSortedItems()) {
            if (!this.items.contains(itemIndex)) continue;
            BookmarkItem item = this.grid.getCalculatedItem(itemIndex);
            int slotIndex = this.grid.gridGenerator.itemToSlot.get(itemIndex);
            Rectangle4i rect = this.grid.getSlotRect(slotIndex % (this.grid.getRows() * this.grid.getColumns()));
            if (startRect == null) {
                startRect = new Point(rect.x - this.shiftX, rect.y - this.shiftY);
            }
            GuiContainerManager.drawItem(mousex + rect.x - startRect.x + 1, mousey + rect.y - startRect.y + 1, item.getItemStack(), true, "");
        }
        GuiContainerManager.drawItems.zLevel -= 100.0f;
    }

    public void update() {
        BookmarkGroup group = this.grid.getGroup(this.bookmarkItem.groupId);
        this.items.clear();
        if (group.collapsed) {
            return;
        }
        for (Map.Entry<Integer, RecipeChainDetails.BookmarkChainItem> entry : this.grid.gridGenerator.caclulatedItems.entrySet()) {
            if (!this.containsItem(entry.getValue().getItem())) continue;
            this.items.add(entry.getKey());
        }
        if (this.isCollapsedRecipe && group.crafting != null) {
            for (Map.Entry<Integer, Object> entry : group.crafting.itemToRecipe.entrySet()) {
                if (!this.bookmarkItem.equalsRecipe((Recipe.RecipeId)entry.getValue(), this.bookmarkItem.groupId)) continue;
                this.items.add(entry.getKey());
            }
        }
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public int getItemIndex() {
        return this.items.isEmpty() ? -1 : this.items.get(0);
    }

    private boolean canInsert(BookmarkGroup group) {
        return group.viewMode == BookmarkPanel.BookmarkViewMode.TODO_LIST && !group.collapsed;
    }

    public void mouseDragged(int mousex, int mousey) {
        BookmarkPanel.BookmarkViewMode sortViewMode = this.grid.getViewMode(this.bookmarkItem.groupId);
        BookmarksGridSlot mouseOverSlot = (BookmarksGridSlot)this.grid.getSlotMouseOver(mousex, mousey);
        if (this.crossGroup) {
            Rectangle4i topLeftSlot = this.grid.getSlotRect(0);
            mouseOverSlot = (BookmarksGridSlot)this.grid.getSlotMouseOver(topLeftSlot.x, mousey);
            if (mouseOverSlot != null) {
                float ySlot = (float)(mousey - topLeftSlot.y) / (float)ItemsGrid.SLOT_SIZE;
                int overRowIndex = (int)ySlot;
                int beforeGroupId = this.grid.getRowGroupId(overRowIndex - 1);
                int afterGroupId = this.grid.getRowGroupId(overRowIndex + 1);
                int overGroupId = mouseOverSlot.getGroupId();
                ySlot -= (float)overRowIndex;
                if (overGroupId == this.bookmarkItem.groupId && !this.items.contains(mouseOverSlot.itemIndex)) {
                    this.grid.moveItem(this, mouseOverSlot.itemIndex);
                } else if ((double)ySlot <= 0.25) {
                    BookmarkGroup group = this.grid.getGroup(beforeGroupId);
                    if (beforeGroupId != overGroupId && this.canInsert(group) && !this.existsRecipe(this.bookmarkItem.recipeId, beforeGroupId)) {
                        this.grid.moveItem(this, overRowIndex, beforeGroupId, false);
                    }
                } else if ((double)ySlot > 0.25 && (double)ySlot <= 0.5) {
                    if (beforeGroupId == overGroupId) {
                        return;
                    }
                    if (overGroupId != 0 && beforeGroupId != 0) {
                        beforeGroupId = 0;
                    }
                    if (overGroupId == 0 && beforeGroupId != 0 && afterGroupId != 0) {
                        return;
                    }
                    if (this.canInsert(this.grid.getGroup(beforeGroupId)) && !this.existsRecipe(this.bookmarkItem.recipeId, beforeGroupId)) {
                        this.grid.moveItem(this, overRowIndex, beforeGroupId, false);
                    }
                } else if ((double)ySlot > 0.5 && (double)ySlot < 0.75) {
                    if (afterGroupId == overGroupId) {
                        return;
                    }
                    if (overGroupId != 0 && afterGroupId != 0) {
                        afterGroupId = 0;
                    }
                    if (overGroupId == 0 && beforeGroupId != 0 && afterGroupId != 0) {
                        return;
                    }
                    if (this.canInsert(this.grid.getGroup(afterGroupId)) && !this.existsRecipe(this.bookmarkItem.recipeId, afterGroupId)) {
                        this.grid.moveItem(this, overRowIndex, afterGroupId, true);
                    }
                } else if ((double)ySlot >= 0.75) {
                    BookmarkGroup group = this.grid.getGroup(afterGroupId);
                    if (afterGroupId != overGroupId && this.canInsert(group) && !this.existsRecipe(this.bookmarkItem.recipeId, afterGroupId)) {
                        this.grid.moveItem(this, overRowIndex, afterGroupId, true);
                    }
                }
            } else {
                int overRowIndex = this.grid.getHoveredRowIndex(false);
                int overGroupId = this.grid.getRowGroupId(overRowIndex);
                if (overRowIndex != -1 && overGroupId == this.bookmarkItem.groupId) {
                    int absoluteSlotIndex = ((this.grid.getPage() - 1) * this.grid.getRows() + overRowIndex) * this.grid.getColumns();
                    if (absoluteSlotIndex < this.grid.gridGenerator.itemToSlot.getOrDefault(this.getItemIndex(), -1)) {
                        this.grid.moveItem(this, overRowIndex, overGroupId, true);
                    } else {
                        this.grid.moveItem(this, overRowIndex, overGroupId, false);
                    }
                }
            }
        } else if (mouseOverSlot != null && !this.items.contains(mouseOverSlot.itemIndex) && mouseOverSlot.getGroupId() == this.bookmarkItem.groupId && (sortViewMode == BookmarkPanel.BookmarkViewMode.DEFAULT || sortViewMode == BookmarkPanel.BookmarkViewMode.TODO_LIST && mouseOverSlot.getBookmarkItem().equalsRecipe(this.bookmarkItem))) {
            this.grid.moveItem(this, mouseOverSlot.itemIndex);
        }
    }

    private boolean existsRecipe(Recipe.RecipeId recipeId, int groupId) {
        if (recipeId == null) {
            return false;
        }
        for (int itemIndex = 0; itemIndex < this.grid.bookmarkItems.size(); ++itemIndex) {
            if (this.items.contains(itemIndex) || !this.grid.bookmarkItems.get(itemIndex).equalsRecipe(recipeId, groupId)) continue;
            return true;
        }
        return false;
    }

    public List<BookmarkItem> getBookmarkItems() {
        BookmarkGroup group = this.grid.getGroup(this.bookmarkItem.groupId);
        ArrayList<BookmarkItem> items = new ArrayList<BookmarkItem>();
        ArrayList recipeRelations = new ArrayList();
        if (this.isCollapsedRecipe && group.crafting != null) {
            recipeRelations.addAll(group.crafting.recipeRelations.getOrDefault(this.bookmarkItem.recipeId, Collections.emptySet()));
        }
        for (BookmarkItem item : this.grid.bookmarkItems) {
            if (!this.containsItem(item) && (item.groupId != this.bookmarkItem.groupId || !recipeRelations.contains(item.recipeId))) continue;
            items.add(item);
        }
        return items;
    }

    public boolean containsItem(BookmarkItem slotItem) {
        return this.moveRecipe ? this.bookmarkItem.equalsRecipe(slotItem) : this.bookmarkItem.equals(slotItem);
    }
}

