/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.config.preset;

import codechicken.core.gui.GuiWidget;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.ItemsGrid;
import codechicken.nei.Label;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PresetsList;
import codechicken.nei.TextField;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.config.preset.CheckboxButton;
import codechicken.nei.config.preset.PresetItemsGrid;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerTooltipHandler;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class LeftPanel
extends GuiWidget {
    protected static final int INPUT_HEIGHT = 20;
    public final PresetItemsGrid grid = new PresetItemsGrid(){

        @Override
        protected ItemFilter getFilter() {
            Set<String> identifiers = LeftPanel.this.preset.items;
            return item -> identifiers.contains(PresetsList.Preset.getIdentifier(item));
        }

        @Override
        protected boolean isSelected(ItemStack stack) {
            return LeftPanel.this.mouseSelection != null && LeftPanel.this.mouseSelection.items.contains(stack);
        }

        @Override
        protected ItemsGrid.MouseContext getMouseContext(int mousex, int mousey) {
            Object hovered = this.getSlotMouseOver(mousex, mousey);
            if (hovered != null) {
                return new ItemsGrid.MouseContext(((ItemsGrid.ItemsGridSlot)hovered).slotIndex, ((ItemsGrid.ItemsGridSlot)hovered).slotIndex / this.columns, ((ItemsGrid.ItemsGridSlot)hovered).slotIndex % this.columns);
            }
            return null;
        }
    };
    protected Label nameLabel = new Label(NEIClientUtils.translate("presets.name", new Object[0]), false);
    protected TextField nameField = new TextField("name"){

        @Override
        public void onTextChange(String oldText) {
            LeftPanel.this.preset.name = this.text();
        }
    };
    protected Label modeLabel = new Label(NEIClientUtils.translate("presets.mode", new Object[0]), false);
    protected CheckboxButton modeHide;
    protected CheckboxButton modeSubset;
    protected CheckboxButton modeRemove;
    protected CheckboxButton modeGroup;
    protected CheckboxButton enabledButton;
    protected final PresetsList.Preset preset;
    protected MouseSelection mouseSelection;

    public LeftPanel(final PresetsList.Preset preset) {
        super(1, 0, 2, 2);
        this.preset = preset;
        this.nameField.setText(preset.name);
        this.modeHide = new CheckboxButton(NEIClientUtils.translate("presets.mode.hide", new Object[0])){

            @Override
            public boolean isChecked() {
                return preset.mode == PresetsList.PresetMode.HIDE;
            }

            @Override
            protected void onChange() {
                preset.mode = this.checked ? PresetsList.PresetMode.HIDE : null;
            }
        };
        this.modeSubset = new CheckboxButton(NEIClientUtils.translate("presets.mode.subset", new Object[0])){

            @Override
            public boolean isChecked() {
                return preset.mode == PresetsList.PresetMode.SUBSET;
            }

            @Override
            protected void onChange() {
                preset.mode = this.checked ? PresetsList.PresetMode.SUBSET : null;
            }
        };
        this.modeRemove = new CheckboxButton(NEIClientUtils.translate("presets.mode.remove", new Object[0])){

            @Override
            public boolean isChecked() {
                return preset.mode == PresetsList.PresetMode.REMOVE;
            }

            @Override
            protected void onChange() {
                preset.mode = this.checked ? PresetsList.PresetMode.REMOVE : null;
            }
        };
        this.modeGroup = new CheckboxButton(NEIClientUtils.translate("presets.mode.group", new Object[0])){

            @Override
            public boolean isChecked() {
                return preset.mode == PresetsList.PresetMode.GROUP;
            }

            @Override
            protected void onChange() {
                preset.mode = this.checked ? PresetsList.PresetMode.GROUP : null;
            }
        };
        this.enabledButton = new CheckboxButton(NEIClientUtils.translate("presets.enabled", new Object[0])){

            @Override
            public boolean isChecked() {
                return preset.enabled;
            }

            @Override
            protected void onChange() {
                preset.enabled = this.checked;
            }
        };
        this.grid.restartFilter();
    }

    public void mouseClicked(int x, int y, int button) {
        Object slot;
        this.grid.mouseClicked(x, y, button);
        if (this.modeHide.contains(x, y)) {
            this.modeHide.handleClick(x, y, button);
        }
        if (this.modeSubset.contains(x, y)) {
            this.modeSubset.handleClick(x, y, button);
        }
        if (this.modeRemove.contains(x, y)) {
            this.modeRemove.handleClick(x, y, button);
        }
        if (this.modeGroup.contains(x, y)) {
            this.modeGroup.handleClick(x, y, button);
        }
        if (this.enabledButton.contains(x, y)) {
            this.enabledButton.handleClick(x, y, button);
        }
        if (this.nameField.contains(x, y)) {
            this.nameField.handleClick(x, y, button);
        } else {
            this.nameField.onGuiClick(x, y);
        }
        if (this.mouseSelection == null && button == 0 && (slot = this.grid.getSlotMouseOver(x, y)) != null) {
            this.mouseSelection = new MouseSelection(((ItemsGrid.ItemsGridSlot)slot).itemIndex, this.grid.getItemRect(((ItemsGrid.ItemsGridSlot)slot).itemIndex));
        }
    }

    protected void onItemsChanges() {
    }

    public void mouseMovedOrUp(int x, int y, int button) {
        this.nameField.mouseUp(x, y, button);
        if (this.mouseSelection != null && button == 0) {
            Object hoverSlot = this.grid.getSlotMouseOver(x, y);
            if (hoverSlot != null && ((ItemsGrid.ItemsGridSlot)hoverSlot).itemIndex == this.mouseSelection.startIndex) {
                this.preset.items.remove(PresetsList.Preset.getIdentifier(((ItemsGrid.ItemsGridSlot)hoverSlot).getItemStack()));
            } else if (!this.mouseSelection.items.isEmpty()) {
                for (ItemStack stack : this.mouseSelection.items) {
                    this.preset.items.remove(PresetsList.Preset.getIdentifier(stack));
                }
            }
            this.mouseSelection = null;
            this.onItemsChanges();
        }
    }

    public void mouseDragged(int x, int y, int button, long time) {
        Object slot;
        this.nameField.mouseDragged(x, y, button, time);
        if (this.mouseSelection != null && button == 0 && (slot = this.grid.getSlotMouseOver(x, y)) != null && ((ItemsGrid.ItemsGridSlot)slot).itemIndex != this.mouseSelection.endIndex) {
            this.mouseSelection.endIndex = ((ItemsGrid.ItemsGridSlot)slot).itemIndex;
            this.mouseSelection.items.clear();
            Rectangle4i rec = this.grid.getItemRect(((ItemsGrid.ItemsGridSlot)slot).itemIndex);
            Rectangle4i sel = new Rectangle4i(Math.min(rec.x, this.mouseSelection.startX), Math.min(rec.y, this.mouseSelection.startY), Math.max(rec.x, this.mouseSelection.startX) - Math.min(rec.x, this.mouseSelection.startX), Math.max(rec.y, this.mouseSelection.startY) - Math.min(rec.y, this.mouseSelection.startY));
            for (int ix = sel.x; ix <= sel.x + sel.w; ix += ItemsGrid.SLOT_SIZE) {
                for (int iy = sel.y; iy <= sel.y + sel.h; iy += ItemsGrid.SLOT_SIZE) {
                    Object over = this.grid.getSlotMouseOver(ix, iy);
                    if (over == null) continue;
                    this.mouseSelection.items.add(((ItemsGrid.ItemsGridSlot)over).getItemStack());
                }
            }
        }
    }

    public void update() {
        int CHECKBOX_WIDTH = (this.width - 12) / 4;
        this.nameLabel.x = this.x + 2;
        this.nameLabel.y = this.y + 4;
        this.nameLabel.w = this.width;
        this.nameLabel.h = 10;
        this.nameField.x = this.x;
        this.nameField.y = this.nameLabel.y + this.nameLabel.h;
        this.nameField.w = this.width - CHECKBOX_WIDTH - 6;
        this.nameField.h = 20;
        this.enabledButton.x = this.nameField.x + this.nameField.w + 6;
        this.enabledButton.y = this.nameField.y;
        this.enabledButton.w = CHECKBOX_WIDTH;
        this.enabledButton.h = 20;
        this.modeLabel.x = this.x + 2;
        this.modeLabel.y = this.nameField.y + this.nameField.h + 6;
        this.modeLabel.w = this.width;
        this.modeLabel.h = 10;
        this.modeRemove.w = this.modeGroup.w = CHECKBOX_WIDTH;
        this.modeSubset.w = this.modeGroup.w;
        this.modeHide.w = this.modeGroup.w;
        this.modeGroup.h = 20;
        this.modeRemove.h = 20;
        this.modeSubset.h = 20;
        this.modeHide.h = 20;
        this.modeRemove.y = this.modeGroup.y = this.modeLabel.y + this.modeLabel.h;
        this.modeSubset.y = this.modeGroup.y;
        this.modeHide.y = this.modeGroup.y;
        this.modeHide.x = this.x + 1;
        this.modeSubset.x = this.modeHide.x + this.modeHide.w + 6;
        this.modeRemove.x = this.modeSubset.x + this.modeSubset.w + 6;
        this.modeGroup.x = this.modeRemove.x + this.modeRemove.w + 6;
        this.grid.setGridSize(this.x + 1, this.modeHide.y + this.modeHide.h + 2, this.width - 2, this.height - (this.modeHide.y + this.modeHide.h + 2));
        this.grid.refresh(null);
    }

    public void draw(int mousex, int mousey, float frame) {
        this.nameLabel.draw(mousex, mousey);
        this.nameField.draw(mousex, mousey);
        this.modeLabel.draw(mousex, mousey);
        this.modeHide.draw(mousex, mousey);
        this.modeSubset.draw(mousex, mousey);
        this.modeRemove.draw(mousex, mousey);
        this.modeGroup.draw(mousex, mousey);
        this.enabledButton.draw(mousex, mousey);
        RenderHelper.enableGUIStandardItemLighting();
        GL11.glPushMatrix();
        GL11.glEnable((int)32826);
        this.grid.draw(mousex, mousey);
        GL11.glDisable((int)32826);
        GL11.glPopMatrix();
        RenderHelper.enableStandardItemLighting();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> handleTooltip(int mousex, int mousey, List<String> tooltip) {
        Object over = this.grid.getSlotMouseOver(mousex, mousey);
        if (over != null) {
            tooltip = GuiContainerManager.itemDisplayNameMultiline(((ItemsGrid.ItemsGridSlot)over).getItemStack(), null, true);
            LinkedList<IContainerTooltipHandler> linkedList = GuiContainerManager.tooltipHandlers;
            synchronized (linkedList) {
                for (IContainerTooltipHandler handler : GuiContainerManager.tooltipHandlers) {
                    tooltip = handler.handleItemTooltip(null, ((ItemsGrid.ItemsGridSlot)over).getItemStack(), mousex, mousey, tooltip);
                }
            }
            if (!tooltip.isEmpty()) {
                tooltip.set(0, tooltip.get(0) + "\u00a7h");
            }
        } else if (this.modeHide.contains(mousex, mousey)) {
            tooltip.add(NEIClientUtils.translate("presets.mode.hide.tip", new Object[0]));
        } else if (this.modeSubset.contains(mousex, mousey)) {
            tooltip.add(NEIClientUtils.translate("presets.mode.subset.tip", new Object[0]));
        } else if (this.modeRemove.contains(mousex, mousey)) {
            tooltip.add(NEIClientUtils.translate("presets.mode.remove.tip", new Object[0]));
        } else if (this.modeGroup.contains(mousex, mousey)) {
            tooltip.add(NEIClientUtils.translate("presets.mode.group.tip", new Object[0]));
        }
        return tooltip;
    }

    public void keyTyped(char c, int keycode) {
        this.nameField.handleKeyPress(keycode, c);
    }

    public void mouseScrolled(int x, int y, int scroll) {
        if (this.grid.contains(x, y)) {
            this.grid.shiftPage(-scroll);
        }
    }

    protected static class MouseSelection {
        public int startX = -1;
        public int startY = -1;
        public int startIndex = -1;
        public int endIndex = -1;
        public Set<ItemStack> items = new HashSet<ItemStack>();

        public MouseSelection(int slotIndex, Rectangle4i rec) {
            this.endIndex = slotIndex;
            this.startIndex = slotIndex;
            this.startX = rec.x;
            this.startY = rec.y;
        }
    }
}

