/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe.stackinfo;

import codechicken.nei.api.IStackStringifyHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GTFluidStackStringifyHandler
implements IStackStringifyHandler {
    protected static Class<?> itemFluidDisplay = null;
    protected static Method getFluidDisplayStack = null;
    protected static Method getFluidFromDisplayStack = null;
    public static boolean replaceAE2FCFluidDrop = false;
    private static Class<?> gtMetaGeneratedTool = null;
    private static Field playSound = null;

    @Override
    public NBTTagCompound convertItemStackToNBT(ItemStack stack, boolean saveStackSize) {
        FluidStack fluidStack;
        if ((replaceAE2FCFluidDrop || stack.getItem() != GameRegistry.findItem((String)"ae2fc", (String)"fluid_drop")) && (fluidStack = this.getFluid(stack)) != null) {
            NBTTagCompound nbTag = new NBTTagCompound();
            nbTag.setString("gtFluidName", fluidStack.getFluid().getName());
            nbTag.setInteger("Count", saveStackSize ? fluidStack.amount : 144);
            return nbTag;
        }
        return null;
    }

    @Override
    public ItemStack convertNBTToItemStack(NBTTagCompound nbtTag) {
        if (getFluidDisplayStack != null && nbtTag.hasKey("gtFluidName")) {
            String fluidName = nbtTag.getString("gtFluidName");
            Fluid fluid = FluidRegistry.getFluid((String)fluidName);
            int amount = nbtTag.getInteger("Count");
            try {
                Object obj = getFluidDisplayStack.invoke(null, new FluidStack(fluid, amount), true);
                if (obj != null) {
                    return (ItemStack)obj;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public FluidStack getFluid(ItemStack stack) {
        Item item = stack.getItem();
        try {
            if (getFluidFromDisplayStack != null && itemFluidDisplay != null && itemFluidDisplay.isInstance(item)) {
                Object obj = getFluidFromDisplayStack.invoke(null, stack);
                if (obj != null) {
                    return (FluidStack)obj;
                }
            } else {
                NBTTagCompound nbtTag;
                Fluid fluid;
                if (item == GameRegistry.findItem((String)"ae2fc", (String)"fluid_packet")) {
                    NBTTagCompound nbtTag2 = stack.getTagCompound();
                    return FluidStack.loadFluidStackFromNBT((NBTTagCompound)((NBTTagCompound)nbtTag2.getTag("FluidStack")));
                }
                if (item == GameRegistry.findItem((String)"ae2fc", (String)"fluid_drop") && (fluid = FluidRegistry.getFluid((String)(nbtTag = stack.getTagCompound()).getString("Fluid").toLowerCase())) != null) {
                    FluidStack fluidStack = new FluidStack(fluid, stack.stackSize);
                    if (nbtTag.hasKey("FluidTag")) {
                        fluidStack.tag = nbtTag.getCompoundTag("FluidTag");
                    }
                    return fluidStack;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void pauseItemDamageSound(boolean pause) {
        if (playSound != null) {
            try {
                playSound.setBoolean(null, !pause);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        try {
            ClassLoader loader = GTFluidStackStringifyHandler.class.getClassLoader();
            Class gtUtility = ReflectionHelper.getClass((ClassLoader)loader, (String[])new String[]{"gregtech.api.util.GTUtility", "gregtech.api.util.GT_Utility"});
            itemFluidDisplay = ReflectionHelper.getClass((ClassLoader)loader, (String[])new String[]{"gregtech.common.items.ItemFluidDisplay", "gregtech.common.items.GT_FluidDisplayItem"});
            getFluidFromDisplayStack = gtUtility.getMethod("getFluidFromDisplayStack", ItemStack.class);
            getFluidDisplayStack = gtUtility.getMethod("getFluidDisplayStack", FluidStack.class, Boolean.TYPE);
            gtMetaGeneratedTool = ReflectionHelper.getClass((ClassLoader)loader, (String[])new String[]{"gregtech.api.items.MetaGeneratedTool", "gregtech.api.items.GT_MetaGenerated_Tool"});
            playSound = gtMetaGeneratedTool.getDeclaredField("playSound");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

