/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiNEIButton
extends GuiButton {
    protected static final ResourceLocation guiTex = new ResourceLocation("textures/gui/widgets.png");

    public GuiNEIButton(int i, int j, int k, int l, int i1, String s) {
        super(i, j, k, l, i1, s);
    }

    public void drawButton(Minecraft minecraft, int x, int y) {
        if (!this.visible) {
            return;
        }
        minecraft.renderEngine.bindTexture(guiTex);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean mouseOver = x >= this.xPosition && y >= this.yPosition && x < this.xPosition + this.width && y < this.yPosition + this.height;
        int k = this.getHoverState(mouseOver);
        this.drawTexturedModalRect(this.xPosition, this.yPosition, 0, 46 + k * 20, this.width / 2, this.height / 2);
        this.drawTexturedModalRect(this.xPosition + this.width / 2, this.yPosition, 200 - this.width / 2, 46 + k * 20, this.width / 2, this.height / 2);
        this.drawTexturedModalRect(this.xPosition, this.yPosition + this.height / 2, 0, 46 + k * 20 + 20 - this.height / 2, this.width / 2, this.height / 2);
        this.drawTexturedModalRect(this.xPosition + this.width / 2, this.yPosition + this.height / 2, 200 - this.width / 2, 46 + k * 20 + 20 - this.height / 2, this.width / 2, this.height / 2);
        this.mouseDragged(minecraft, x, y);
        this.drawContent(minecraft, x, y, mouseOver);
    }

    protected int getTextColour(boolean mouseOver) {
        int color = 0xE0E0E0;
        if (!this.enabled) {
            color = -6250336;
        } else if (mouseOver) {
            color = 0xFFFFA0;
        }
        return color;
    }

    protected void drawContent(Minecraft minecraft, int y, int x, boolean mouseOver) {
        FontRenderer fontrenderer = minecraft.fontRenderer;
        int color = this.getTextColour(mouseOver);
        this.drawCenteredString(fontrenderer, this.displayString, this.xPosition + this.width / 2, this.yPosition + (this.height - 8) / 2, color);
    }
}

