/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.Button;
import codechicken.nei.CollapsibleItems;
import codechicken.nei.ItemCraftablesPanel;
import codechicken.nei.ItemHistoryPanel;
import codechicken.nei.ItemList;
import codechicken.nei.ItemPanels;
import codechicken.nei.ItemQuantityField;
import codechicken.nei.ItemsGrid;
import codechicken.nei.ItemsPanelGrid;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PanelWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;

public class ItemPanel
extends PanelWidget<ItemsPanelGrid> {
    @Deprecated
    private int itemsPerPage = 0;
    @Deprecated
    public static ArrayList<ItemStack> items = new ArrayList();
    @Deprecated
    public ArrayList<ItemStack> realItems = new ArrayList();
    public ItemHistoryPanel historyPanel = new ItemHistoryPanel();
    public ItemCraftablesPanel craftablesPanel = new ItemCraftablesPanel();
    protected Button toggleGroups;

    @Override
    public ItemStack getStackMouseOver(int mousex, int mousey) {
        return super.getStackMouseOver(mousex, mousey);
    }

    public ItemPanel() {
        this.grid = new ItemsPanelGrid();
    }

    public static void updateItemList(ArrayList<ItemStack> newItems) {
        ((ItemsPanelGrid)ItemPanels.itemPanel.getGrid()).setItems(newItems);
        ItemPanels.itemPanel.realItems = newItems;
    }

    @Override
    public void init() {
        super.init();
        this.toggleGroups = new Button("G"){

            @Override
            public String getRenderLabel() {
                return NEIClientUtils.translate("itempanel.collapsed.button", new Object[0]);
            }

            @Override
            public String getButtonTip() {
                return NEIClientUtils.translate("itempanel.collapsed.button.tip", new Object[0]);
            }

            @Override
            public boolean onButtonPress(boolean rightclick) {
                CollapsibleItems.toggleGroups(rightclick ? Boolean.valueOf(false) : null);
                ItemList.updateFilter.restart();
                return true;
            }
        };
    }

    @Override
    public ItemPanelSlot getSlotMouseOver(int mousex, int mousey) {
        return ItemPanelSlot.of((ItemsPanelGrid.ItemsPanelGridSlot)((ItemsPanelGrid)this.grid).getSlotMouseOver(mousex, mousey));
    }

    @Override
    public String getLabelText() {
        return String.format("%d/%d", this.getPage(), Math.max(1, this.getNumPages()));
    }

    @Override
    public Rectangle4i calculateBounds() {
        GuiContainer gui = NEIClientUtils.getGuiContainer();
        int width = (gui.width - gui.xSize) / 2 - 4;
        Rectangle4i bounds = new Rectangle4i((gui.width + gui.xSize) / 2 + 2, 2, (gui.width - 176) / 2 - 4, gui.height - 4);
        int paddingLeft = (int)Math.ceil((double)(bounds.w * NEIClientConfig.getSetting("world.panels.items.left").getIntValue()) / 100000.0);
        int paddingTop = (int)Math.ceil((double)(bounds.h * NEIClientConfig.getSetting("world.panels.items.top").getIntValue()) / 100000.0);
        int paddingRight = (int)Math.ceil((double)(bounds.w * NEIClientConfig.getSetting("world.panels.items.right").getIntValue()) / 100000.0);
        int paddingBottom = (int)Math.ceil((double)(bounds.h * NEIClientConfig.getSetting("world.panels.items.bottom").getIntValue()) / 100000.0);
        bounds.h = Math.max(ItemsGrid.SLOT_SIZE, bounds.h - paddingTop - paddingBottom);
        bounds.y += Math.min(paddingTop, bounds.h - ItemsGrid.SLOT_SIZE);
        bounds.w = Math.max(ItemsGrid.SLOT_SIZE, Math.min(bounds.w - paddingLeft - paddingRight, width - paddingRight));
        bounds.x += Math.max(0, width - bounds.w - paddingRight);
        return bounds;
    }

    @Override
    protected int resizeHeader(GuiContainer gui) {
        int marginTop = super.resizeHeader(gui);
        this.toggleGroups.w = this.pageNext.w;
        this.toggleGroups.h = this.pageNext.h;
        this.toggleGroups.y = this.pageNext.y;
        this.toggleGroups.x = this.pageNext.x - this.toggleGroups.w - 2;
        return marginTop;
    }

    @Override
    protected int resizeFooter(GuiContainer gui) {
        int footerY = this.y + this.h;
        int footerHeight = 0;
        if (((ItemsPanelGrid)this.grid).getPerPage() == 0) {
            return 0;
        }
        if (NEIClientConfig.showItemQuantityWidget() || !NEIClientConfig.isSearchWidgetCentered()) {
            footerY = LayoutManager.quantity.y;
            footerHeight = LayoutManager.quantity.h + 2;
        }
        if (NEIClientConfig.showHistoryPanelWidget()) {
            this.historyPanel.x = this.x;
            if (this.historyPanel.setPanelWidth(this.w) != 0) {
                footerY = this.historyPanel.y = footerY - this.historyPanel.h;
                footerHeight += this.historyPanel.h;
            }
        }
        if (NEIClientConfig.showCraftablesPanelWidget()) {
            this.craftablesPanel.x = this.x;
            if (this.craftablesPanel.setPanelWidth(this.w) != 0) {
                footerY = this.craftablesPanel.y = footerY - this.craftablesPanel.h;
                footerHeight += this.craftablesPanel.h;
            }
        }
        return footerHeight;
    }

    @Override
    public void setVisible() {
        super.setVisible();
        if (((ItemsPanelGrid)this.grid).getPerPage() > 0) {
            if (!CollapsibleItems.isEmpty() && !((ItemsPanelGrid)this.grid).isEmpty()) {
                LayoutManager.addWidget(this.toggleGroups);
            }
            if (NEIClientConfig.showCraftablesPanelWidget()) {
                LayoutManager.addWidget(this.craftablesPanel);
            }
            if (NEIClientConfig.showHistoryPanelWidget()) {
                LayoutManager.addWidget(this.historyPanel);
            }
        }
    }

    @Override
    public void resize(GuiContainer gui) {
        super.resize(gui);
        this.historyPanel.resize(gui);
        this.craftablesPanel.resize(gui);
    }

    @Override
    protected ItemStack getDraggedStackWithQuantity(ItemStack itemStack) {
        return ItemQuantityField.prepareStackWithQuantity(itemStack, 0L);
    }

    @Override
    public List<String> handleItemTooltip(ItemStack itemstack, int mousex, int mousey, List<String> currenttip) {
        ItemsPanelGrid.ItemsPanelGridSlot hoverSlot;
        if (!(((ItemsPanelGrid)this.grid).forceExpand || currenttip.isEmpty() || (hoverSlot = (ItemsPanelGrid.ItemsPanelGridSlot)((ItemsPanelGrid)this.grid).getSlotMouseOver(mousex, mousey)) == null || hoverSlot.groupIndex < 0 || !NEIClientConfig.getBooleanSetting("inventory.collapsibleItems.customName") || hoverSlot.extended || "".equals(hoverSlot.displayName))) {
            currenttip.clear();
            currenttip.add(hoverSlot.displayName + "\u00a7h");
        }
        return super.handleItemTooltip(itemstack, mousex, mousey, currenttip);
    }

    @Override
    public boolean handleClick(int mousex, int mousey, int button) {
        ItemsPanelGrid.ItemsPanelGridSlot hoverSlot;
        if (button == 0 && !((ItemsPanelGrid)this.grid).forceExpand && NEIClientUtils.altKey() && (hoverSlot = (ItemsPanelGrid.ItemsPanelGridSlot)((ItemsPanelGrid)this.grid).getSlotMouseOver(mousex, mousey)) != null && hoverSlot.groupIndex >= 0) {
            CollapsibleItems.setExpanded(hoverSlot.groupIndex, !hoverSlot.extended);
            ((ItemsPanelGrid)this.grid).setItems(((ItemsPanelGrid)this.grid).rawItems);
            NEIClientUtils.playClickSound();
            return true;
        }
        return super.handleClick(mousex, mousey, button);
    }

    @Override
    public Map<String, String> handleHotkeys(int mousex, int mousey, Map<String, String> hotkeys) {
        ItemsPanelGrid.ItemsPanelGridSlot hoverSlot = (ItemsPanelGrid.ItemsPanelGridSlot)((ItemsPanelGrid)this.grid).getSlotMouseOver(mousex, mousey);
        if (!((ItemsPanelGrid)this.grid).forceExpand && hoverSlot != null && hoverSlot.groupIndex >= 0 && hoverSlot.groupSize > 1) {
            String message = hoverSlot.extended ? "itempanel.collapsed.hint.collapse" : "itempanel.collapsed.hint.expand";
            hotkeys.put(NEIClientUtils.getKeyName(0x8000000, 0), NEIClientUtils.translate(message, hoverSlot.groupSize));
        }
        return super.handleHotkeys(mousex, mousey, hotkeys);
    }

    public boolean containsWithSubpanels(int px, int py) {
        return this.contains(px, py) || NEIClientConfig.showHistoryPanelWidget() && this.historyPanel.contains(px, py) || NEIClientConfig.showCraftablesPanelWidget() && this.craftablesPanel.contains(px, py);
    }

    @Deprecated
    public static class ItemPanelSlot
    extends ItemsPanelGrid.ItemsPanelGridSlot {
        @Deprecated
        public ItemPanelSlot(int idx, ItemStack item) {
            this(idx, 0, item);
        }

        @Deprecated
        public ItemPanelSlot(int idx) {
            this(idx, 0, ((ItemsPanelGrid)ItemPanels.itemPanel.getGrid()).getItem(idx));
        }

        private ItemPanelSlot(int slotIndex, int itemIndex, ItemStack item) {
            super(slotIndex, itemIndex, item);
        }

        protected static ItemPanelSlot of(ItemsPanelGrid.ItemsPanelGridSlot slot) {
            if (slot != null) {
                ItemPanelSlot customSlot = new ItemPanelSlot(slot.slotIndex, slot.itemIndex, slot.item);
                customSlot.groupIndex = slot.groupIndex;
                customSlot.displayName = slot.displayName;
                customSlot.bgItemStack = slot.bgItemStack;
                customSlot.groupSize = slot.groupSize;
                customSlot.extended = slot.extended;
                customSlot.bgColor = slot.bgColor;
                return customSlot;
            }
            return null;
        }
    }
}

