/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.api.GuiInfo;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.Recipe;
import codechicken.nei.recipe.StackInfo;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

public abstract class ItemsGrid<T extends ItemsGridSlot, M extends MouseContext> {
    public static int SLOT_SIZE = 18;
    public static final Color HIGHLIGHT_COLOR = new Color(-296397483, true);
    protected int width;
    protected int height;
    protected int marginLeft;
    protected int marginTop;
    protected int paddingLeft;
    protected ArrayList<ItemStack> realItems = new ArrayList();
    protected int page;
    protected int perPage;
    protected int rows;
    protected int columns;
    protected boolean[] invalidSlotMap;
    protected ScreenCapture screenCapture = null;

    public ArrayList<ItemStack> getItems() {
        return this.realItems;
    }

    public ItemStack getItem(int itemIndex) {
        return this.realItems.get(itemIndex);
    }

    public int size() {
        return this.realItems.size();
    }

    public boolean isEmpty() {
        return this.realItems.isEmpty();
    }

    public int indexOf(ItemStack stackA, boolean useNBT) {
        for (int idx = 0; idx < this.realItems.size(); ++idx) {
            if (!StackInfo.equalItemAndNBT(stackA, this.realItems.get(idx), useNBT)) continue;
            return idx;
        }
        return -1;
    }

    public void setPage(int page) {
        this.page = Math.max(0, Math.min(page, this.getNumPages() - 1));
        this.onGridChanged();
    }

    public int getPage() {
        return this.page + 1;
    }

    public int getPerPage() {
        return this.perPage;
    }

    public int getNumPages() {
        if (this.perPage > 0) {
            return (int)Math.ceil((float)this.realItems.size() / (float)this.perPage);
        }
        return 0;
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public int getLastRowIndex() {
        List<T> mask = this.getMask();
        return this.columns > 0 && !mask.isEmpty() ? (int)Math.ceil((float)(((ItemsGridSlot)mask.get((int)(mask.size() - 1))).slotIndex + 1) / (float)this.columns) - 1 : 0;
    }

    public void setGridSize(int mleft, int mtop, int w, int h) {
        this.marginLeft = mleft;
        this.marginTop = mtop;
        this.width = Math.max(0, w);
        this.height = Math.max(0, h);
        this.columns = this.width / SLOT_SIZE;
        this.rows = this.height / SLOT_SIZE;
        this.paddingLeft = this.width % SLOT_SIZE / 2;
    }

    public void shiftPage(int shift) {
        if (this.perPage == 0) {
            this.page = 0;
            return;
        }
        int numPages = this.getNumPages();
        int oldPage = this.page;
        this.page += shift;
        if (this.page >= numPages) {
            this.page -= numPages;
        }
        if (this.page < 0) {
            this.page = numPages + this.page;
        }
        this.page = Math.max(0, Math.min(this.page, numPages - 1));
        if (this.page != oldPage) {
            this.onGridChanged();
        }
    }

    protected void onGridChanged() {
        if (this.screenCapture != null) {
            this.screenCapture.refreshBuffer();
        }
    }

    public void onItemsChanged() {
        this.onGridChanged();
    }

    public void refresh(GuiContainer gui) {
        this.updateGuiOverlapSlots(gui);
        this.shiftPage(0);
    }

    protected void updateGuiOverlapSlots(GuiContainer gui) {
        boolean[] oldSlotMap = this.invalidSlotMap;
        int oldRows = this.rows;
        int oldColumns = this.columns;
        this.invalidSlotMap = new boolean[this.rows * this.columns];
        this.perPage = this.columns * this.rows;
        if (gui != null) {
            if (NEIClientConfig.optimizeGuiOverlapComputation()) {
                this.checkGuiOverlap(gui, 0, this.columns - 2, 1);
                this.checkGuiOverlap(gui, this.columns - 1, 1, -1);
            } else {
                this.checkGuiOverlap(gui, 0, this.columns, 1);
            }
        }
        if (oldRows != this.rows || oldColumns != this.columns || !Arrays.equals(oldSlotMap, this.invalidSlotMap)) {
            this.onGridChanged();
        }
    }

    private void checkGuiOverlap(GuiContainer gui, int start, int end, int dir) {
        boolean validColumn = false;
        for (int c = start; !(c == end || NEIClientConfig.optimizeGuiOverlapComputation() && validColumn); c += dir) {
            validColumn = true;
            for (int r = 0; r < this.rows; ++r) {
                int idx = this.columns * r + c;
                if (idx < 0 || idx >= this.invalidSlotMap.length || this.invalidSlotMap[idx] || !GuiInfo.hideItemPanelSlot(gui, this.getSlotRect(r, c))) continue;
                this.invalidSlotMap[idx] = true;
                validColumn = false;
                --this.perPage;
            }
        }
    }

    public T getSlotMouseOver(int mousex, int mousey) {
        if (!this.contains(mousex, mousey)) {
            return null;
        }
        int overRow = this.getRowIndex(mousey);
        int overColumn = this.getColumnIndex(mousex);
        int slt = this.columns * overRow + overColumn;
        if (overRow >= this.rows || overColumn >= this.columns) {
            return null;
        }
        return this.getSlotBySlotIndex(slt);
    }

    public T getSlotBySlotIndex(int slotIndex) {
        return (T)((ItemsGridSlot)this.getMask().stream().filter(item -> item.slotIndex == slotIndex).findAny().orElse(null));
    }

    public T getSlotByItemIndex(int itemIndex) {
        return (T)((ItemsGridSlot)this.getMask().stream().filter(item -> item.itemIndex == itemIndex).findAny().orElse(null));
    }

    public Rectangle4i getItemRect(int itemIndex) {
        T item = this.getSlotByItemIndex(itemIndex);
        return item != null ? this.getSlotRect(((ItemsGridSlot)item).slotIndex) : null;
    }

    public Rectangle4i getSlotRect(int slotIndex) {
        return this.getSlotRect(slotIndex / this.columns, slotIndex % this.columns);
    }

    public Rectangle4i getSlotRect(int row, int column) {
        return new Rectangle4i(this.marginLeft + this.paddingLeft + column * SLOT_SIZE, this.marginTop + row * SLOT_SIZE, SLOT_SIZE, SLOT_SIZE);
    }

    public int getRowIndex(int mousey) {
        return (mousey - this.marginTop) / SLOT_SIZE;
    }

    public int getColumnIndex(int mousex) {
        return (mousex - this.marginLeft - this.paddingLeft) / SLOT_SIZE;
    }

    public boolean isInvalidSlot(int index) {
        return this.invalidSlotMap[index];
    }

    public abstract List<T> getMask();

    protected abstract M getMouseContext(int var1, int var2);

    protected void beforeDrawItems(int mousex, int mousey, M mouseContext) {
        for (ItemsGridSlot item : this.getMask()) {
            item.beforeDraw(this.getSlotRect(item.slotIndex), mouseContext);
        }
        for (ItemsGridSlot item : this.getMask()) {
            item.drawBorder(this.getSlotRect(item.slotIndex));
        }
    }

    protected void afterDrawItems(int mousex, int mousey, M mouseContext) {
        for (ItemsGridSlot item : this.getMask()) {
            item.afterDraw(this.getSlotRect(item.slotIndex), mouseContext);
        }
    }

    public void update() {
    }

    protected void drawItems() {
        for (ItemsGridSlot item : this.getMask()) {
            item.drawItem(this.getSlotRect(item.slotIndex));
        }
    }

    protected int getGridRenderingCacheMode() {
        return NEIClientConfig.getGridRenderingCacheMode();
    }

    public void draw(int mousex, int mousey) {
        if (this.getPerPage() == 0) {
            return;
        }
        int gridRenderingCacheMode = this.getGridRenderingCacheMode();
        M mouseContext = this.getMouseContext(mousex, mousey);
        this.beforeDrawItems(mousex, mousey, mouseContext);
        if (gridRenderingCacheMode > 0) {
            if (this.screenCapture == null) {
                this.screenCapture = new ScreenCapture();
            }
            if (this.screenCapture.needRefresh(gridRenderingCacheMode)) {
                this.screenCapture.captureScreen(() -> {
                    GuiContainerManager.enableMatrixStackLogging();
                    this.drawItems();
                    GuiContainerManager.disableMatrixStackLogging();
                }, gridRenderingCacheMode);
            }
            this.screenCapture.renderCapturedScreen();
        } else {
            GuiContainerManager.enableMatrixStackLogging();
            this.drawItems();
            GuiContainerManager.disableMatrixStackLogging();
        }
        this.afterDrawItems(mousex, mousey, mouseContext);
    }

    public boolean contains(int px, int py) {
        Rectangle4i rect = new Rectangle4i(this.marginLeft + this.paddingLeft, this.marginTop, this.columns * SLOT_SIZE, this.rows * SLOT_SIZE);
        if (!rect.contains(px, py)) {
            return false;
        }
        return !this.isInvalidSlot(this.columns * this.getRowIndex(py) + this.getColumnIndex(px));
    }

    protected static class ScreenCapture {
        private long nextCacheRefresh = 0L;
        private Framebuffer framebuffer = new Framebuffer(1, 1, true);

        public ScreenCapture() {
            this.framebuffer.setFramebufferColor(0.0f, 0.0f, 0.0f, 0.0f);
            Minecraft.getMinecraft().getFramebuffer().bindFramebuffer(false);
        }

        protected int getGridRenderingCacheFPS(int mode) {
            return mode == 1 ? NEIClientConfig.getIntSetting("inventory.gridRenderingCacheFPS") : 0;
        }

        public boolean needRefresh(int mode) {
            Minecraft minecraft = Minecraft.getMinecraft();
            return this.nextCacheRefresh == 0L || this.framebuffer.framebufferWidth != minecraft.displayWidth || this.framebuffer.framebufferHeight != minecraft.displayHeight || this.getGridRenderingCacheFPS(mode) > 0 && this.nextCacheRefresh < System.currentTimeMillis();
        }

        public void refreshBuffer() {
            this.nextCacheRefresh = 0L;
        }

        public void captureScreen(Runnable callback, int mode) {
            GL11.glPushAttrib((int)24640);
            this.resetFramebuffer();
            this.framebuffer.bindFramebuffer(false);
            GL11.glDisable((int)3042);
            GL11.glDepthMask((boolean)true);
            OpenGlHelper.glBlendFunc((int)770, (int)771, (int)770, (int)771);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            callback.run();
            GL11.glPopAttrib();
            Minecraft.getMinecraft().getFramebuffer().bindFramebuffer(false);
            this.nextCacheRefresh = System.currentTimeMillis() + (long)(1000 / Math.max(1, this.getGridRenderingCacheFPS(mode)));
        }

        private void resetFramebuffer() {
            Minecraft minecraft = Minecraft.getMinecraft();
            if (this.framebuffer.framebufferWidth != minecraft.displayWidth || this.framebuffer.framebufferHeight != minecraft.displayHeight) {
                this.framebuffer.createBindFramebuffer(minecraft.displayWidth, minecraft.displayHeight);
                this.framebuffer.setFramebufferFilter(9728);
            } else {
                this.framebuffer.framebufferClear();
            }
            OpenGlHelper.func_153171_g((int)36008, (int)minecraft.getFramebuffer().framebufferObject);
            OpenGlHelper.func_153171_g((int)36009, (int)this.framebuffer.framebufferObject);
            GL30.glBlitFramebuffer((int)0, (int)0, (int)minecraft.displayWidth, (int)minecraft.displayHeight, (int)0, (int)0, (int)minecraft.displayWidth, (int)minecraft.displayHeight, (int)1280, (int)9728);
        }

        public void renderCapturedScreen() {
            this.framebuffer.bindFramebufferTexture();
            Tessellator tessellator = Tessellator.instance;
            Minecraft minecraft = Minecraft.getMinecraft();
            ScaledResolution scaledresolution = new ScaledResolution(minecraft, minecraft.displayWidth, minecraft.displayHeight);
            GL11.glEnable((int)3042);
            OpenGlHelper.glBlendFunc((int)1, (int)771, (int)1, (int)771);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3553);
            tessellator.startDrawingQuads();
            tessellator.addVertexWithUV(0.0, scaledresolution.getScaledHeight_double(), 0.0, 0.0, 0.0);
            tessellator.addVertexWithUV(scaledresolution.getScaledWidth_double(), scaledresolution.getScaledHeight_double(), 0.0, 1.0, 0.0);
            tessellator.addVertexWithUV(scaledresolution.getScaledWidth_double(), 0.0, 0.0, 1.0, 1.0);
            tessellator.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 1.0);
            tessellator.draw();
            this.framebuffer.unbindFramebufferTexture();
        }
    }

    public static class ItemsGridSlot {
        protected static final float DEFAULT_SLOT_SIZE = 18.0f;
        protected static final float LINE_WIDTH = 0.75f;
        public final ItemStack item;
        public final int slotIndex;
        public final int itemIndex;
        public Color borderColor = Color.BLACK;
        public boolean borderLeft = false;
        public boolean borderTop = false;
        public boolean borderRight = false;
        public boolean borderBottom = false;

        public ItemsGridSlot(int slotIndex, int itemIndex, ItemStack itemStack) {
            this.slotIndex = slotIndex;
            this.itemIndex = itemIndex;
            this.item = itemStack;
        }

        public ItemStack getItemStack() {
            return this.item;
        }

        public <M extends MouseContext> void beforeDraw(Rectangle4i rect, M mouseContext) {
            if (mouseContext != null && mouseContext.slotIndex == this.slotIndex) {
                NEIClientUtils.drawRect(rect.x, rect.y, rect.w, rect.h, HIGHLIGHT_COLOR);
            }
        }

        public <M extends MouseContext> void afterDraw(Rectangle4i rect, M mouseContext) {
        }

        public Recipe.RecipeId getRecipeId() {
            return null;
        }

        public void drawItem(Rectangle4i rect) {
            this.drawItem(this.getItemStack(), rect);
        }

        protected void drawItem(ItemStack stack, Rectangle4i rect) {
            if ((float)rect.w != 18.0f) {
                float panelFactor = (float)(rect.w - 2) / 16.0f;
                GL11.glTranslatef((float)(rect.x + 1), (float)(rect.y + 1), (float)0.0f);
                GL11.glScaled((double)panelFactor, (double)panelFactor, (double)1.0);
                GuiContainerManager.drawItem(0, 0, stack, true, "");
                GL11.glScaled((double)(1.0f / panelFactor), (double)(1.0f / panelFactor), (double)1.0);
                GL11.glTranslatef((float)(-1 * (rect.x + 1)), (float)(-1 * (rect.y + 1)), (float)0.0f);
            } else {
                GuiContainerManager.drawItem(rect.x + 1, rect.y + 1, stack, true, "");
            }
        }

        public void drawBorder(Rectangle4i rect) {
            float halfLineWidth = 0.375f;
            if (this.borderLeft) {
                NEIClientUtils.drawRect((float)rect.x - halfLineWidth, (float)rect.y + halfLineWidth, 0.75, rect.h, this.borderColor);
            }
            if (this.borderRight) {
                NEIClientUtils.drawRect((float)(rect.x + rect.w) - halfLineWidth, (float)rect.y - halfLineWidth, 0.75, rect.h, this.borderColor);
            }
            if (this.borderTop) {
                NEIClientUtils.drawRect((float)rect.x - halfLineWidth, (float)rect.y - halfLineWidth, rect.w, 0.75, this.borderColor);
            }
            if (this.borderBottom) {
                NEIClientUtils.drawRect((float)rect.x + halfLineWidth, (float)(rect.y + rect.h) - halfLineWidth, rect.w, 0.75, this.borderColor);
            }
        }
    }

    public static class MouseContext {
        public final int slotIndex;
        public final int columnIndex;
        public final int rowIndex;

        public MouseContext(int slotIndex, int rowIndex, int columnIndex) {
            this.slotIndex = slotIndex;
            this.rowIndex = rowIndex;
            this.columnIndex = columnIndex;
        }

        public int hashCode() {
            return Objects.hash(this.rowIndex, this.slotIndex, this.columnIndex);
        }

        public boolean equals(Object obj) {
            if (obj instanceof MouseContext) {
                MouseContext context = (MouseContext)obj;
                return this.columnIndex == context.columnIndex && this.rowIndex == context.rowIndex && this.slotIndex == context.slotIndex;
            }
            return false;
        }
    }
}

