/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.bookmark;

import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.bookmark.BookmarkGrid;
import codechicken.nei.bookmark.BookmarkItem;
import codechicken.nei.bookmark.BookmarksGridSlot;
import codechicken.nei.guihook.GuiContainerManager;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.lwjgl.opengl.GL11;

public class SortableGroup {
    public int groupId;
    public BookmarkGrid grid;
    public int shiftX = 0;
    public int shiftY = 0;

    public SortableGroup(BookmarkGrid grid, int groupId) {
        this.grid = grid;
        this.groupId = groupId;
    }

    public void postDraw(int mousex, int mousey) {
        Point startRect = null;
        GuiContainerManager.drawItems.zLevel += 100.0f;
        for (BookmarksGridSlot slot : this.grid.getMask()) {
            if (slot.getGroupId() != this.groupId) continue;
            Rectangle4i rect = this.grid.getSlotRect(slot.slotIndex);
            if (startRect == null) {
                startRect = new Point(rect.x - this.shiftX, rect.y - this.shiftY);
            }
            GuiContainerManager.drawItem(mousex + rect.x - startRect.x + 1, mousey + rect.y - startRect.y + 1, slot.getItemStack(), true, "");
        }
        if (startRect != null) {
            int startRowIndex = -1;
            int endRowIndex = 0;
            for (int rowIndex = 0; rowIndex < this.grid.getRows(); ++rowIndex) {
                if (this.grid.getRowGroupId(rowIndex) != this.groupId) continue;
                if (startRowIndex == -1) {
                    startRowIndex = rowIndex;
                }
                endRowIndex = rowIndex;
            }
            GL11.glPushMatrix();
            GL11.glTranslated((double)(mousex - startRect.x), (double)(mousey - startRect.y), (double)0.0);
            this.grid.drawGroup(this.groupId, startRowIndex, endRowIndex);
            GL11.glPopMatrix();
        }
        GuiContainerManager.drawItems.zLevel -= 100.0f;
    }

    public List<BookmarkItem> getBookmarkItems() {
        ArrayList<BookmarkItem> items = new ArrayList<BookmarkItem>();
        for (BookmarkItem item : this.grid.bookmarkItems) {
            if (item.groupId != this.groupId) continue;
            items.add(item);
        }
        return items;
    }
}

