/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.commands;

import codechicken.nei.ItemList;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.util.ItemUntranslator;
import java.io.File;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;

public class CommandUntranslator
extends CommandBase {
    public String getCommandName() {
        return "untranslator";
    }

    public String getCommandUsage(ICommandSender sender) {
        return "/untranslator dump OR /untranslator clear";
    }

    public int getRequiredPermissionLevel() {
        return 0;
    }

    public void processCommand(ICommandSender sender, String[] args) {
        String command;
        String string = command = args.length == 0 ? null : args[0];
        if ("dump".equals(command)) {
            if (ItemList.items.isEmpty()) {
                CommandUntranslator.sendChatErrorMessage(sender, "nei.chat.untranslator.dump.error", new Object[0]);
                return;
            }
            CommandUntranslator.sendChatInfoMessage(sender, "nei.chat.untranslator.dump.start", new Object[0]);
            ItemUntranslator.getInstance().generateUntranslatedNames();
            CommandUntranslator.sendChatInfoMessage(sender, "nei.chat.untranslator.dump.finish", new Object[0]);
            if (NEIClientConfig.enableItemUntranslator()) {
                ItemUntranslator.getInstance().load();
            }
        } else if ("clear".equals(command)) {
            File file = new File(NEIClientConfig.configDir, "untranslator.cfg");
            if (file.exists() && file.delete()) {
                CommandUntranslator.sendChatInfoMessage(sender, "nei.chat.untranslator.clear", new Object[0]);
                if (NEIClientConfig.enableItemUntranslator()) {
                    ItemUntranslator.getInstance().load();
                }
            } else {
                CommandUntranslator.sendChatErrorMessage(sender, "nei.chat.untranslator.clear.error", new Object[0]);
            }
        } else {
            CommandUntranslator.sendChatErrorMessage(sender, this.getCommandUsage(sender), new Object[0]);
        }
    }

    private static void sendChatInfoMessage(ICommandSender sender, String translationKey, Object ... args) {
        sender.addChatMessage(new ChatComponentTranslation(translationKey, args).setChatStyle(new ChatStyle().setColor(EnumChatFormatting.AQUA)));
    }

    private static void sendChatErrorMessage(ICommandSender sender, String translationKey, Object ... args) {
        sender.addChatMessage(new ChatComponentTranslation(translationKey, args).setChatStyle(new ChatStyle().setColor(EnumChatFormatting.RED)));
    }
}

